/*
 * Decompiled with CFR 0.152.
 */
package electric.util.java;

import electric.util.array.ArrayUtil;

public final class JavaNames {
    private static String prefix = "_";
    private static String substitute = "_";
    public static final String[] keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "cast", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "future", "generic", "goto", "if", "implements", "import", "inner", "instanceof", "int", "interface", "long", "native", "new", "null", "operator", "outer", "package", "private", "protected", "public", "rest", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "var", "void", "volatile", "while"};

    public static boolean isJavaKeyword(String name) {
        return ArrayUtil.indexOf(name, keywords) != -1;
    }

    public static boolean isJavaIdentifier(String name) {
        if (name.length() == 0) {
            return false;
        }
        if (JavaNames.isJavaKeyword(name)) {
            return false;
        }
        char[] chars = name.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            return false;
        }
        int i = 1;
        while (i < chars.length) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getJavaName(Class type) {
        if (type.isArray()) {
            return JavaNames.getJavaName(type.getComponentType()) + "[]";
        }
        return type.getName();
    }

    public static String getShortJavaName(Class type) {
        if (type.isArray()) {
            return JavaNames.getShortJavaName(type.getComponentType()) + "[]";
        }
        String name = type.getName();
        return name.startsWith("java.lang.") ? name.substring(10) : name;
    }

    public static String getJavaName(String name) {
        if (JavaNames.isJavaKeyword(name)) {
            return prefix + name;
        }
        StringBuffer buffer = new StringBuffer();
        char[] chars = name.toCharArray();
        if (!Character.isJavaIdentifierStart(chars[0])) {
            buffer.append(prefix);
        }
        int i = 0;
        while (i < chars.length) {
            if (!Character.isJavaIdentifierPart(chars[i])) {
                buffer.append(substitute);
            } else {
                buffer.append(chars[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void setPrefix(String prefix) {
        JavaNames.prefix = prefix;
    }

    public static void setSubstitute(String substitute) {
        JavaNames.substitute = substitute;
    }
}

