/*
 * Decompiled with CFR 0.152.
 */
package electric.util.io;

import electric.util.io.Streams;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ChunkedInputStream
extends FilterInputStream {
    private boolean reachedEOF = false;
    private int chunkLength = -1;
    private byte[] oneByteBuffer = new byte[1];

    public ChunkedInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public synchronized int read() throws IOException {
        int b = this.read(this.oneByteBuffer, 0, 1);
        return b == 1 ? this.oneByteBuffer[0] & 0xFF : -1;
    }

    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.reachedEOF) {
            return -1;
        }
        if (this.chunkLength == -1) {
            this.chunkLength = this.getChunkLength();
        }
        if (this.chunkLength > 0) {
            int totalRead;
            if (length > this.chunkLength) {
                length = this.chunkLength;
            }
            if ((totalRead = this.in.read(buffer, offset, length)) == -1) {
                throw new EOFException("eof has been reached too early");
            }
            this.chunkLength -= totalRead;
            if (this.chunkLength == 0) {
                this.in.read();
                this.in.read();
                this.chunkLength = -1;
            }
            return totalRead;
        }
        while (!Streams.readLine(this.in).equals("")) {
        }
        return -1;
    }

    private int getChunkLength() throws IOException {
        String chunkLengthLine = Streams.readLine(this.in);
        int index = chunkLengthLine.indexOf(59);
        if (index != -1) {
            chunkLengthLine = chunkLengthLine.substring(0, index);
        }
        try {
            return Integer.parseInt(chunkLengthLine.trim(), 16);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("can not find valid chunk length " + chunkLengthLine);
        }
    }
}

