/*
 * Decompiled with CFR 0.152.
 */
package electric.util.http;

import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.http.IHTTPConstants;
import electric.util.lex.Lex;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;

public final class HTTPUtil
implements IHTTPConstants {
    public static String decode(String string) {
        if (string.indexOf(43) == -1 && string.indexOf(37) == -1) {
            return string.trim();
        }
        return URLDecoder.decode(string).trim();
    }

    public static String encode(String string) {
        return URLEncoder.encode(string.trim());
    }

    public static String getContextPath(XURL xurl) {
        return xurl.getFile() == null || xurl.getFile().length() == 1 ? "" : xurl.getFile();
    }

    public static XURL getTCPXURL(XURL xurl) {
        if ("http".equals(xurl.getProtocol())) {
            return new XURL("tcp", xurl.getHost(), xurl.getPort(), null, null);
        }
        if ("https".equals(xurl.getProtocol())) {
            return new XURL("ssl", xurl.getHost(), xurl.getPort(), null, null);
        }
        throw new RuntimeException("unknown protocol. cannot create url");
    }

    public static String getQueryString(String path) {
        if (path == null) {
            return null;
        }
        int index = path.indexOf("?");
        return index == -1 ? null : path.substring(index + 1);
    }

    public static String getParameter(String path, String key) {
        if (path == null) {
            return null;
        }
        int index = path.indexOf("?" + key);
        if (index == -1) {
            index = path.indexOf("&" + key);
        }
        if (index == -1) {
            return null;
        }
        int end = index + key.length() + 2;
        StringBuffer value = new StringBuffer();
        while (end < path.length()) {
            char ch;
            if ((ch = path.charAt(end++)) == '&') break;
            value.append(ch);
        }
        return HTTPUtil.decode(value.toString());
    }

    public static boolean hasParameter(String path, String key) {
        return path != null && (path.indexOf("?" + key) != -1 || path.indexOf("&" + key) != -1);
    }

    public static String removeParameter(String path, String key) {
        int index = path.indexOf("?" + key);
        if (index == -1) {
            index = path.indexOf("&" + key);
        }
        if (index == -1) {
            return path;
        }
        int amp = path.indexOf(38, index + 1);
        if (amp == -1) {
            return path.substring(0, index);
        }
        return path.substring(0, index) + path.substring(amp);
    }

    public static String addParameter(String path, String key) {
        key = HTTPUtil.encode(key);
        return path + (path.indexOf("?") == -1 ? "?" : "&") + key;
    }

    public static String addParameter(String path, String key, String value) {
        key = HTTPUtil.encode(key);
        value = HTTPUtil.encode(value);
        return path + (path.indexOf("?") == -1 ? "?" : "&") + key + "=" + value;
    }

    public static String[][] getParametersAsArray(String string) throws IOException {
        Lex lex = new Lex(string, "=&", 1);
        String[][] strings = new String[0][0];
        while (!lex.eof()) {
            String key = HTTPUtil.decode(lex.readToken());
            String value = "";
            if (!lex.eof() && lex.readChar() == 61) {
                value = HTTPUtil.decode(lex.readToPattern("&", 10));
            }
            strings = (String[][])ArrayUtil.addElement(strings, new String[]{key, value});
        }
        return strings;
    }

    public static Context getParametersAsContext(String string) throws IOException {
        Context context = new Context();
        String[][] strings = HTTPUtil.getParametersAsArray(string);
        int i = 0;
        while (i < strings.length) {
            context.addProperty(strings[i][0], strings[i][1]);
            ++i;
        }
        return context;
    }

    public static void addParameters(Hashtable parameters, String string) throws IOException {
        String[][] strings = HTTPUtil.getParametersAsArray(string);
        int i = 0;
        while (i < strings.length) {
            String key = strings[i][0];
            String value = strings[i][1];
            String[] values = (String[])parameters.get(key);
            if (values == null) {
                parameters.put(key, new String[]{value});
            } else {
                parameters.put(key, ArrayUtil.addElement(values, value));
            }
            ++i;
        }
    }

    public static boolean isDIMEMultipart(String type) {
        if (type == null) {
            return false;
        }
        return type.equalsIgnoreCase("application/dime");
    }

    public static boolean isMIMEMultipart(String type) {
        if (type == null) {
            return false;
        }
        if (type.length() < "Multipart/Related".length()) {
            return false;
        }
        type = type.substring(0, "Multipart/Related".length());
        return type.equalsIgnoreCase("Multipart/Related");
    }

    public static boolean isMultipart(String type) {
        return type != null && (HTTPUtil.isMIMEMultipart(type) || HTTPUtil.isDIMEMultipart(type));
    }

    public static boolean isKeepAlive(Context context) {
        String keepAlive = (String)Context.getProperty(context, "keepAlive");
        return keepAlive == null || keepAlive.equalsIgnoreCase("true") || keepAlive.equalsIgnoreCase("yes");
    }

    public static boolean isKeepAlive(String connectionHeader, String version) {
        if (version.equals("HTTP/1.0")) {
            return connectionHeader != null && connectionHeader.equalsIgnoreCase("Keep-Alive");
        }
        return connectionHeader == null || !connectionHeader.equalsIgnoreCase("Close");
    }
}

