/*
 * Decompiled with CFR 0.152.
 */
package electric.util.fileloader.filesystem;

import electric.util.fileloader.IFileEntry;
import electric.util.string.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

class FileSystemEntry
implements IFileEntry {
    private File file;

    public FileSystemEntry(File file) throws FileNotFoundException {
        this.file = file;
        if (!file.exists()) {
            throw new FileNotFoundException("cannot find file " + file.getAbsolutePath());
        }
    }

    public String toString() {
        return "FileSystemEntry( " + this.getAbsolutePath() + " )";
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public InputStream openStream() throws IOException {
        return this.isDirectory() ? null : new FileInputStream(this.file);
    }

    public String getName() {
        return Strings.getURN(this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }
}

