/*
 * Decompiled with CFR 0.152.
 */
package electric.util.file;

import electric.util.file.AnyFileFilter;
import electric.util.io.Streams;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public final class FileUtil
implements ILoggingConstants {
    public static FilenameFilter ANY_FILE = new AnyFileFilter();

    public static void saveFile(String directory, String name, String content, String extension) throws IOException {
        FileUtil.saveFile(directory, name, content, extension, null);
    }

    public static void saveFile(String directory, String name, String content, String extension, String comment) throws IOException {
        if (!directory.equals("")) {
            File dir = new File(directory);
            dir.mkdirs();
        }
        File file = new File(directory + name + extension);
        if (comment != null) {
            System.out.println("write file " + file + " [" + comment + "]");
        } else {
            System.out.println("write file " + file);
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream output = new FileOutputStream(file);
        output.write(content.getBytes());
        output.close();
    }

    public static URL getURL(File file) throws MalformedURLException {
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return new URL("file", "", path);
    }

    public static File[] listFiles(File file) {
        return FileUtil.listFiles(file, false, null);
    }

    public static File[] listFiles(File file, FilenameFilter filter) {
        return FileUtil.listFiles(file, false, filter);
    }

    public static File[] listFiles(File file, boolean recurse, FilenameFilter filter) {
        String[] filenames;
        String[] stringArray = filenames = filter != null ? file.list(filter) : file.list();
        if (filenames == null) {
            return new File[0];
        }
        int n = filenames.length;
        Vector<File> files = new Vector<File>(n, 20);
        int i = 0;
        while (i < n) {
            File fileObj = new File(file.getPath(), filenames[i]);
            if (recurse && fileObj.isDirectory()) {
                File[] subDirFiles = FileUtil.listFiles(fileObj, recurse, filter);
                int k = 0;
                while (k < subDirFiles.length) {
                    files.addElement(subDirFiles[k]);
                    ++k;
                }
            }
            files.addElement(fileObj);
            ++i;
        }
        Object[] fileArray = new File[files.size()];
        files.copyInto(fileArray);
        return fileArray;
    }

    public static void delete(File file) {
        if (file.isDirectory()) {
            File[] files = FileUtil.listFiles(file);
            int i = 0;
            while (i < files.length) {
                FileUtil.delete(files[i]);
                ++i;
            }
        }
        file.delete();
    }

    public static boolean delete(File directory, boolean recurse) {
        return FileUtil.delete(directory, recurse, ANY_FILE);
    }

    public static boolean delete(File directory, boolean recurse, FilenameFilter filter) {
        boolean failed = false;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("directory argument must represent a file directory, not a plain file");
        }
        File[] files = FileUtil.listFiles(directory, true, null);
        int i = 0;
        while (i < files.length) {
            if (recurse && files[i].isDirectory() && !FileUtil.delete(files[i], true, filter)) {
                failed = true;
            }
            if ((filter.accept(directory, files[i].getName()) || files[i].isDirectory() && FileUtil.listFiles(files[i]).length == 0) && !files[i].delete()) {
                failed = true;
            }
            ++i;
        }
        return failed;
    }

    public static void copyFiles(File sourceDir, File targetDir) throws IOException {
        if (!targetDir.exists()) {
            if (Log.isLogging(ILoggingConstants.FILE_EVENT)) {
                Log.log(ILoggingConstants.FILE_EVENT, (Object)("creating directory structure for " + targetDir.getAbsolutePath()));
            }
            targetDir.mkdirs();
        } else if (!targetDir.isDirectory()) {
            throw new IllegalArgumentException("target directory must point to a directory");
        }
        if (!sourceDir.exists()) {
            throw new IllegalArgumentException("source directory cannot be found");
        }
        if (!sourceDir.isDirectory()) {
            throw new IllegalArgumentException("source directory must point to a directory");
        }
        int length = sourceDir.getAbsolutePath().length();
        File[] sourceFiles = FileUtil.listFiles(sourceDir, true, null);
        int i = 0;
        while (i < sourceFiles.length) {
            File targetFile = new File(targetDir, sourceFiles[i].getAbsolutePath().substring(length));
            if (sourceFiles[i].isDirectory()) {
                targetFile.mkdirs();
            } else {
                new File(targetFile.getParent()).mkdirs();
                try {
                    if (Log.isLogging(ILoggingConstants.FILE_EVENT)) {
                        Log.log(ILoggingConstants.FILE_EVENT, (Object)("copying " + sourceFiles[i].getAbsolutePath()));
                    }
                    FileInputStream input = new FileInputStream(sourceFiles[i]);
                    FileOutputStream output = new FileOutputStream(targetFile.getAbsolutePath());
                    Streams.copy((InputStream)input, (OutputStream)output, (int)sourceFiles[i].length(), 10240);
                    input.close();
                    output.close();
                }
                catch (FileNotFoundException exception) {
                    exception.printStackTrace();
                }
            }
            ++i;
        }
    }

    public static boolean isDirectory(String path) {
        try {
            return new File(path).isDirectory();
        }
        catch (SecurityException exception) {
            return false;
        }
    }

    public static boolean isEmpty(File directory) {
        if (!directory.isDirectory()) {
            return false;
        }
        File[] files = directory.listFiles();
        return files != null && files.length == 0;
    }

    public static String currentDirectoryPath() throws IOException {
        return new File("").getCanonicalPath();
    }
}

