/*
 * Decompiled with CFR 0.152.
 */
package electric.util.exec;

import electric.util.io.PipeInputStream;
import electric.util.thread.ThreadPool;
import java.io.IOException;
import java.io.OutputStream;

public class JavaApplication {
    private Process process;
    private OutputStream output;

    public JavaApplication() {
        this(System.out);
    }

    public JavaApplication(OutputStream output) {
        this.output = output != null ? output : System.out;
    }

    public void start(String classname, String[] vmParams, String[] appParams) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        StringBuffer command = new StringBuffer();
        command.append("java -classpath ");
        command.append(System.getProperties().get("java.class.path").toString());
        int i = 0;
        while (i < vmParams.length) {
            command.append(" " + vmParams[i]);
            ++i;
        }
        command.append(" " + classname + " ");
        int i2 = 0;
        while (i2 < appParams.length) {
            command.append(appParams[i2] + " ");
            ++i2;
        }
        this.process = runtime.exec(command.toString());
        ThreadPool pool = ThreadPool.getShared();
        PipeInputStream inputTask = new PipeInputStream(this.process.getInputStream(), this.output);
        PipeInputStream errorTask = new PipeInputStream(this.process.getErrorStream(), this.output);
        pool.run(inputTask);
        pool.run(errorTask);
    }

    public void stop() {
        this.process.destroy();
    }
}

