/*
 * Decompiled with CFR 0.152.
 */
package electric.util.dime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DIMEUtils {
    public static int calculatePadding(int length) {
        if (length == 0) {
            return 0;
        }
        if (length < 4) {
            return 4 - length;
        }
        int padding = 4 - length % 4;
        if (padding == 4) {
            padding = 0;
        }
        return padding;
    }

    public static short readShort(InputStream istr) throws IOException {
        int shortHi = (istr.read() & 0xFF) << 8;
        int shortLo = istr.read() & 0xFF;
        return (short)(shortHi + shortLo);
    }

    public static int readInt(InputStream istr) throws IOException {
        int byte0 = (istr.read() & 0xFF) << 24;
        int byte1 = (istr.read() & 0xFF) << 16;
        int byte2 = (istr.read() & 0xFF) << 8;
        int byte3 = istr.read() & 0xFF;
        int value = byte0 + byte1 + byte2 + byte3;
        return value;
    }

    public static void writeShort(OutputStream ostr, int value) throws IOException {
        byte hi = (byte)(value >>> 8);
        byte lo = (byte)(value >>> 0);
        byte[] bytes = new byte[]{hi, lo};
        ostr.write(bytes);
    }

    public static void writeInt(OutputStream ostr, int value) throws IOException {
        byte b0 = (byte)(value >>> 24);
        byte b1 = (byte)(value >>> 16);
        byte b2 = (byte)(value >>> 8);
        byte b3 = (byte)(value >>> 0);
        byte[] bytes = new byte[]{b0, b1, b2, b3};
        ostr.write(bytes);
    }
}

