/*
 * Decompiled with CFR 0.152.
 */
package electric.util.dictionary.transactional;

import electric.transaction.Transaction;
import electric.util.dictionary.IDictionary;
import electric.util.dictionary.persistent.IPersistentDictionary;
import electric.util.dictionary.persistent.PersistentDictionary;
import electric.util.dictionary.transactional.View;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public class TransactionalDictionary
extends Dictionary {
    private IPersistentDictionary persistentDictionary;
    private Hashtable transactionToView = new Hashtable();

    public TransactionalDictionary(String root) {
        this(root, false);
    }

    public TransactionalDictionary(String root, boolean delete) {
        this(root, delete, true);
    }

    public TransactionalDictionary(String root, boolean delete, boolean lazy) {
        this.persistentDictionary = new PersistentDictionary(root, delete, lazy);
    }

    public TransactionalDictionary(IPersistentDictionary persistentDictionary) {
        this.persistentDictionary = persistentDictionary;
    }

    public String toString() {
        return "TransactionalDictionary( " + this.persistentDictionary + ", views " + this.transactionToView + " )";
    }

    public String getRoot() {
        if (this.persistentDictionary instanceof PersistentDictionary) {
            return ((PersistentDictionary)this.persistentDictionary).getRoot();
        }
        throw new UnsupportedOperationException("getRoot() only supported when using the file system for underlying persistence");
    }

    public Object get(Object key) {
        return this.getDictionary().get(key);
    }

    public Object put(Object key, Object value) {
        return this.getDictionary().put(key, value);
    }

    public Object remove(Object key) {
        return this.getDictionary().remove(key);
    }

    public int size() {
        return this.getDictionary().size();
    }

    public boolean isEmpty() {
        return this.getDictionary().isEmpty();
    }

    public Enumeration keys() {
        return this.getDictionary().keys();
    }

    public Enumeration elements() {
        return this.getDictionary().elements();
    }

    public void clear() {
        this.persistentDictionary.clear();
    }

    public void delete() {
        this.persistentDictionary.delete();
    }

    Object load(Object key) {
        return this.persistentDictionary.load(key);
    }

    public Object peek(Object key) {
        return this.getDictionary().peek(key);
    }

    public void setSync(boolean flag) {
        this.persistentDictionary.setSync(flag);
    }

    public boolean getSync() {
        return this.persistentDictionary.getSync();
    }

    private synchronized IDictionary getDictionary() {
        Transaction transaction = Transaction.current();
        if (transaction == null) {
            return this.persistentDictionary;
        }
        View view = (View)this.transactionToView.get(transaction);
        if (view == null) {
            view = new View(this, transaction);
            this.transactionToView.put(transaction, view);
        }
        return view;
    }

    void removeView(Transaction transaction) {
        this.transactionToView.remove(transaction);
    }

    public IPersistentDictionary getPersistentDictionary() {
        return this.persistentDictionary;
    }

    public boolean getEncoded() {
        return this.persistentDictionary.getEncoded();
    }

    public void setEncoded(boolean encoded) {
        this.persistentDictionary.setEncoded(encoded);
    }
}

