/*
 * Decompiled with CFR 0.152.
 */
package electric.util.codegen;

import electric.util.array.ArrayUtil;
import electric.util.codegen.ClassNameType;
import electric.util.codegen.IJVMConstants;
import electric.util.codegen.NameAndType;
import electric.util.reflect.JavaComment;
import electric.util.reflect.JavaMethod;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

public final class ClassReader
implements IJVMConstants {
    public short minorVersion;
    public short majorVersion;
    public Object[] constants;
    public short accessFlags;
    public String thisClass;
    public String superClass;
    public String[] interfaces;
    public JavaMethod[] methods;

    public ClassReader(byte[] bytes) throws IOException {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(bytes));
        long magicNumber = input.readInt();
        this.minorVersion = input.readShort();
        this.majorVersion = input.readShort();
        int constantPoolCount = input.readShort();
        this.constants = new Object[constantPoolCount];
        int i = 1;
        while (i < constantPoolCount) {
            Object constant;
            this.constants[i] = constant = this.readConstant(input);
            if (constant instanceof Double || constant instanceof Long) {
                ++i;
            }
            ++i;
        }
        this.accessFlags = input.readShort();
        this.thisClass = this.getClassName(input.readShort());
        short superClassIndex = input.readShort();
        if (superClassIndex > 0) {
            this.superClass = this.getClassName(superClassIndex);
        }
        int interfaceCount = input.readShort();
        this.interfaces = new String[interfaceCount];
        int i2 = 0;
        while (i2 < interfaceCount) {
            this.interfaces[i2] = this.getClassName(input.readShort());
            ++i2;
        }
        int fieldCount = input.readShort();
        int i3 = 0;
        while (i3 < fieldCount) {
            this.readField(input);
            ++i3;
        }
        int methodCount = input.readShort();
        this.methods = new JavaMethod[methodCount];
        int i4 = 0;
        while (i4 < methodCount) {
            this.methods[i4] = this.readMethod(input);
            ++i4;
        }
        int attributeCount = input.readShort();
        int i5 = 0;
        while (i5 < attributeCount) {
            this.readAttribute(input);
            ++i5;
        }
    }

    private Object readConstant(DataInput input) throws IOException {
        byte tag = input.readByte();
        switch (tag) {
            case 1: {
                return input.readUTF();
            }
            case 3: {
                return new Integer(input.readInt());
            }
            case 4: {
                return new Float(input.readFloat());
            }
            case 5: {
                return new Long(input.readLong());
            }
            case 6: {
                return new Double(input.readDouble());
            }
            case 7: {
                return new Short(input.readShort());
            }
            case 8: {
                return new Short(input.readShort());
            }
            case 9: 
            case 10: 
            case 11: {
                short classIndex = input.readShort();
                short nameAndTypeIndex = input.readShort();
                return new ClassNameType(classIndex, nameAndTypeIndex);
            }
            case 12: {
                short nameIndex = input.readShort();
                short descriptorIndex = input.readShort();
                return new NameAndType(nameIndex, descriptorIndex);
            }
        }
        throw new IOException("unrecognized tag " + tag);
    }

    private String getClassName(int index) {
        short nameIndex = (Short)this.constants[index];
        return (String)this.constants[nameIndex];
    }

    private void readField(DataInput input) throws IOException {
        short accessFlags = input.readShort();
        short nameIndex = input.readShort();
        short descriptorIndex = input.readShort();
        int attributesCount = input.readShort();
        int i = 0;
        while (i < attributesCount) {
            this.readAttribute(input);
            ++i;
        }
    }

    private JavaMethod readMethod(DataInput input) throws IOException {
        short accessFlags = input.readShort();
        String methodName = (String)this.constants[input.readShort()];
        String descriptor = (String)this.constants[input.readShort()];
        String[] types = this.getArgTypes(descriptor);
        String[] argTypes = new String[types.length - 1];
        String[] argNames = new String[types.length - 1];
        int[] argIndices = new int[types.length - 1];
        int offset = (accessFlags & 8) != 0 ? 0 : 1;
        int i = 0;
        while (i < argTypes.length) {
            String type;
            argTypes[i] = type = types[i];
            argIndices[i] = offset++;
            if (type.equals("long") || type.equals("double")) {
                offset += 2;
            }
            ++i;
        }
        int attributesCount = input.readShort();
        int i2 = 0;
        while (i2 < attributesCount) {
            short attributeNameIndex = input.readShort();
            int attributeLength = input.readInt();
            String name = (String)this.constants[attributeNameIndex];
            if (name.equals("Code")) {
                short maxStack = input.readShort();
                short maxLocals = input.readShort();
                int codeLength = input.readInt();
                byte[] code = new byte[codeLength];
                input.readFully(code);
                int exceptionTableLength = input.readShort();
                int j = 0;
                while (j < exceptionTableLength) {
                    short startPc = input.readShort();
                    short endPc = input.readShort();
                    short handlerPc = input.readShort();
                    short catchType = input.readShort();
                    ++j;
                }
                int attributesCount2 = input.readShort();
                int j2 = 0;
                while (j2 < attributesCount2) {
                    short attributeNameIndex2 = input.readShort();
                    String attributeName = (String)this.constants[attributeNameIndex2];
                    int attributeLength2 = input.readInt();
                    if (attributeName.equals("LocalVariableTable")) {
                        int localVariableTableLength = input.readShort();
                        int k = 0;
                        while (k < localVariableTableLength) {
                            short startPc = input.readShort();
                            short length = input.readShort();
                            short nameIndex3 = input.readShort();
                            short descriptorIndex3 = input.readShort();
                            short index = input.readShort();
                            int z = 0;
                            while (z < argTypes.length) {
                                if (argIndices[z] == index) {
                                    argNames[z] = (String)this.constants[nameIndex3];
                                    break;
                                }
                                ++z;
                            }
                            ++k;
                        }
                    } else {
                        byte[] bytes2 = new byte[attributeLength2];
                        input.readFully(bytes2);
                    }
                    ++j2;
                }
            } else {
                byte[] bytes = new byte[attributeLength];
                input.readFully(bytes);
            }
            ++i2;
        }
        if (argNames.length > 0 && argNames[0] == null) {
            int i3 = 0;
            while (i3 < argNames.length) {
                argNames[i3] = "arg" + i3;
                ++i3;
            }
        }
        return new JavaMethod(methodName, argTypes, argNames, types[types.length - 1], new String[0], new JavaComment());
    }

    private void readAttribute(DataInput input) throws IOException {
        short nameIndex = input.readShort();
        int attributeLength = input.readInt();
        byte[] bytes = new byte[attributeLength];
        input.readFully(bytes);
    }

    private String[] getArgTypes(String descriptor) {
        String[] argTypes = new String[]{};
        int index = 0;
        int dimension = 0;
        while (index < descriptor.length()) {
            StringBuffer buffer;
            char c;
            if ((c = descriptor.charAt(index++)) == '(' || c == ')') continue;
            if (c == '[') {
                ++dimension;
                continue;
            }
            String argType = null;
            if (c == 'B') {
                argType = "byte";
            } else if (c == 'C') {
                argType = "char";
            } else if (c == 'D') {
                argType = "double";
            } else if (c == 'F') {
                argType = "float";
            } else if (c == 'I') {
                argType = "int";
            } else if (c == 'J') {
                argType = "long";
            } else if (c == 'S') {
                argType = "short";
            } else if (c == 'V') {
                argType = "void";
            } else if (c == 'Z') {
                argType = "boolean";
            } else if (c == 'L') {
                buffer = new StringBuffer();
                while ((c = descriptor.charAt(index++)) != ';') {
                    buffer.append(c == '/' ? (char)'.' : (char)c);
                }
                argType = buffer.toString();
            }
            if (dimension > 0) {
                buffer = new StringBuffer();
                buffer.append(argType);
                int i = 0;
                while (i < dimension) {
                    buffer.append("[]");
                    ++i;
                }
                argType = buffer.toString();
                dimension = 0;
            }
            argTypes = (String[])ArrayUtil.addElement(argTypes, argType);
        }
        return argTypes;
    }
}

