/*
 * Decompiled with CFR 0.152.
 */
package electric.util.array;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.Random;

public final class ArrayUtil {
    private static final Class BYTE_ARRAY = new byte[0].getClass();
    private static final Random random = new Random();

    public static Object addElement(Object array, Object element) {
        int length = Array.getLength(array);
        Object newarray = Array.newInstance(array.getClass().getComponentType(), length + 1);
        System.arraycopy(array, 0, newarray, 0, length);
        Array.set(newarray, length, element);
        return newarray;
    }

    public static int[] addElement(int[] array, int element) {
        int length = array.length;
        int[] newarray = new int[length + 1];
        System.arraycopy(array, 0, newarray, 0, length);
        newarray[length] = element;
        return newarray;
    }

    public static Object addElements(Object array1, Object array2) {
        int length1 = Array.getLength(array1);
        int length2 = Array.getLength(array2);
        Object newarray = Array.newInstance(array1.getClass().getComponentType(), length1 + length2);
        System.arraycopy(array1, 0, newarray, 0, length1);
        System.arraycopy(array2, 0, newarray, length1, length2);
        return newarray;
    }

    public static Object grow(Object array, int newLength) {
        int oldLength = Array.getLength(array);
        Object newarray = Array.newInstance(array.getClass().getComponentType(), newLength);
        System.arraycopy(array, 0, newarray, 0, oldLength);
        return newarray;
    }

    public static Object shrink(Object array, int newLength) {
        Object newarray = Array.newInstance(array.getClass().getComponentType(), newLength);
        System.arraycopy(array, 0, newarray, 0, newLength);
        return newarray;
    }

    public static Object insertElement(Object array, Object element) {
        return ArrayUtil.insertElementAt(array, element, 0);
    }

    public static Object insertElementAt(Object array, Object element, int index) {
        int length = Array.getLength(array);
        Object newarray = Array.newInstance(array.getClass().getComponentType(), length + 1);
        if (index > 0) {
            System.arraycopy(array, 0, newarray, 0, index);
        }
        Array.set(newarray, index, element);
        System.arraycopy(array, index, newarray, index + 1, length - index);
        return newarray;
    }

    public static Object removeElement(Object array, Object element) {
        int length = Array.getLength(array);
        int i = 0;
        while (i < length) {
            if (element.equals(Array.get(array, i))) {
                return ArrayUtil.removeElementAt(array, i);
            }
            ++i;
        }
        return array;
    }

    public static Object removeElements(Object array1, Object array2) {
        int length = Array.getLength(array2);
        int i = 0;
        while (i < length) {
            array1 = ArrayUtil.removeElement(array1, Array.get(array2, i));
            ++i;
        }
        return array1;
    }

    public static Object removeElementIdentity(Object array, Object element) {
        int length = Array.getLength(array);
        int i = 0;
        while (i < length) {
            if (element == Array.get(array, i)) {
                return ArrayUtil.removeElementAt(array, i);
            }
            ++i;
        }
        return array;
    }

    public static Object removeElementAt(Object oldarray, int index) {
        int length = Array.getLength(oldarray);
        Object newarray = Array.newInstance(oldarray.getClass().getComponentType(), length - 1);
        System.arraycopy(oldarray, 0, newarray, 0, index);
        System.arraycopy(oldarray, index + 1, newarray, index, length - index - 1);
        return newarray;
    }

    public static int indexOf(int value, int[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(Object value, Object[] array) {
        int i = 0;
        while (i < array.length) {
            if (ArrayUtil.equals(array[i], value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfIdentity(Object value, Object[] array) {
        int i = 0;
        while (i < array.length) {
            if (value == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (!ArrayUtil.equals(array1[i], array2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(byte[] array1, byte[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (array1[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(Object object1, Object object2) {
        if (object1 == null && object2 == null) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        return object1.equals(object2);
    }

    public static boolean isPrimitiveArray(Object possibleArray) {
        return ArrayUtil.isPrimitiveArray(possibleArray.getClass());
    }

    public static boolean isPrimitiveArray(Class arrayClass) {
        while (arrayClass.isArray()) {
            arrayClass = arrayClass.getComponentType();
        }
        return arrayClass.isPrimitive();
    }

    public static int getNumberOfDimensions(Object array) {
        return ArrayUtil.getNumberOfDimensions(array.getClass());
    }

    public static int getNumberOfDimensions(Class arrayClass) {
        int dimensions = 0;
        while (arrayClass.isArray()) {
            arrayClass = arrayClass.getComponentType();
            ++dimensions;
        }
        return dimensions;
    }

    public static Class getBaseClass(Object array) {
        return ArrayUtil.getBaseClass(array.getClass());
    }

    public static Class getBaseClass(Class arrayClass) {
        while (arrayClass.isArray()) {
            arrayClass = arrayClass.getComponentType();
        }
        return arrayClass;
    }

    public static boolean contains(Object value, Object[] array) {
        return ArrayUtil.indexOf(value, array) != -1;
    }

    public static byte[] toBytes(Object object, String encoding) throws UnsupportedEncodingException {
        if (BYTE_ARRAY.isInstance(object)) {
            return (byte[])object;
        }
        if (object == null) {
            return "null".getBytes(encoding);
        }
        if (object instanceof Throwable) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(output);
            ((Throwable)object).printStackTrace(writer);
            writer.flush();
            writer.close();
            return output.toByteArray();
        }
        return object.toString().getBytes(encoding);
    }

    public static Object randomizeOrder(Object oldArray) {
        int length = Array.getLength(oldArray);
        Object newArray = Array.newInstance(oldArray.getClass().getComponentType(), length);
        System.arraycopy(oldArray, 0, newArray, 0, length);
        int i = 0;
        while (i < length) {
            int j = ArrayUtil.nextInt(length);
            if (i != j) {
                Object objectAtI = Array.get(newArray, i);
                Object objectAtJ = Array.get(newArray, j);
                Array.set(newArray, j, objectAtI);
                Array.set(newArray, i, objectAtJ);
            }
            ++i;
        }
        return newArray;
    }

    public static synchronized int nextInt(int max) {
        return Math.abs(random.nextInt()) % max;
    }
}

