/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.util;

import electric.uddi.ICommand;
import electric.uddi.IUDDIConstants;
import electric.uddi.UDDIException;
import electric.util.product.Product;
import electric.xml.Elements;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralWriter;
import java.io.IOException;
import java.lang.reflect.Array;

public final class UDDIUtil
implements IUDDIConstants {
    public static String toString(ICommand command) {
        try {
            LiteralWriter writer = new LiteralWriter();
            command.write(writer);
            return writer.getElement().toString();
        }
        catch (IOException exception) {
            return exception.toString();
        }
    }

    public static void writeList(IWriter writer, String tag, ISerializable[] objects) throws IOException {
        IWriter itemWriter = writer.writeElement(tag);
        UDDIUtil.writeList(itemWriter, objects);
    }

    public static void writeList(IWriter writer, ISerializable[] objects) throws IOException {
        int i = 0;
        while (i < objects.length) {
            objects[i].write(writer);
            ++i;
        }
    }

    public static void writeStringList(IWriter writer, String name, String[] strings) {
        int i = 0;
        while (i < strings.length) {
            writer.writeString(name, strings[i]);
            ++i;
        }
    }

    public static Object readList(IReader reader, Class javaClass) {
        if (reader == null) {
            return Array.newInstance(javaClass, 0);
        }
        return UDDIUtil.readList(reader.getReaders(), javaClass);
    }

    public static Object readList(IReader[] readers, Class javaClass) {
        Object array = Array.newInstance(javaClass, readers.length);
        int i = 0;
        while (i < readers.length) {
            try {
                ISerializable object = (ISerializable)javaClass.newInstance();
                object.read(readers[i]);
                Array.set(array, i, object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            ++i;
        }
        return array;
    }

    public static String[] getTexts(IReader reader, String path) {
        Elements elements = reader.getElement().getElements(path);
        String[] strings = new String[elements.size()];
        int i = 0;
        while (i < strings.length) {
            strings[i] = elements.next().getTextString();
            ++i;
        }
        return strings;
    }

    public static void checkVersion(String version, String legalVersion) throws UDDIException {
        if (!version.equals(legalVersion)) {
            throw new UDDIException(10050);
        }
    }

    static {
        Product.startup();
    }
}

