/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server.xdb;

import electric.uddi.server.IUDDIStorage;
import electric.uddi.server.UDDIDictionary;
import electric.uddi.server.xdb.TypeSelector;
import electric.uddi.server.xdb.XDBDictionary;
import electric.util.dictionary.transactional.TransactionalDictionary;
import electric.xdb.XDBException;
import electric.xdb.server.IXDBServer;

public class XDBUDDIStorage
implements IUDDIStorage {
    private IXDBServer server;
    private boolean delete;

    public XDBUDDIStorage(IXDBServer server, boolean delete) {
        this.server = server;
        this.delete = delete;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public boolean doesDictionaryExist(Class type) {
        try {
            return this.server.getDataCountForSelector(new TypeSelector(type)) > 0;
        }
        catch (XDBException exception) {
            return false;
        }
    }

    public UDDIDictionary newDictionary(Class type, boolean encoded) {
        XDBDictionary persistentDictionary = new XDBDictionary(this.server, type);
        persistentDictionary.setEncoded(encoded);
        TransactionalDictionary dictionary = new TransactionalDictionary(persistentDictionary);
        return new UDDIDictionary(dictionary);
    }
}

