/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server.sql;

import electric.sql.SQLClient;
import electric.sql.mapping.ITable;
import electric.uddi.AccessPoint;
import electric.uddi.Binding;
import electric.uddi.Description;
import electric.uddi.TModelInstance;
import electric.uddi.server.sql.AccessPointTable;
import electric.uddi.server.sql.DescriptionTable;
import electric.uddi.server.sql.TModelTable;
import electric.util.WrappedException;
import electric.util.array.ArrayUtil;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BindingTable
implements ITable {
    private SQLClient sqlClient;
    private DescriptionTable descriptionTable;
    private AccessPointTable accessPointTable;
    private TModelTable tModelTable;

    public BindingTable(String databaseName) {
        this(new SQLClient(databaseName));
    }

    public BindingTable(SQLClient sqlClient) {
        this.sqlClient = sqlClient;
        this.initTables();
    }

    private void initTables() {
        this.descriptionTable = new DescriptionTable(this.sqlClient);
        this.accessPointTable = new AccessPointTable(this.sqlClient);
        this.tModelTable = new TModelTable(this.sqlClient);
    }

    public void insert(Object value) throws SQLException {
        Binding binding = (Binding)value;
        String bindingKey = binding.getBindingKey();
        String serviceKey = binding.getServiceKey();
        String hostingRedirector = binding.getHostingRedirector();
        String userName = binding.getUserName();
        Description[] descriptions = binding.getDescriptions();
        AccessPoint accessPoint = binding.getAccessPoint();
        TModelInstance[] tModelInstances = binding.getTModelInstances();
        String sql = "INSERT into binding (BINDING_KEY, SERVICE_KEY, HOSTING_REDIRECTOR, USER_NAME) VALUES ('" + bindingKey + "','" + serviceKey + "','" + hostingRedirector + "','" + userName + "')";
        try {
            this.sqlClient.insert(sql);
        }
        catch (SQLException exception) {
            throw new WrappedException(exception);
        }
        this.descriptionTable.insert(descriptions, bindingKey);
        this.accessPointTable.insert(accessPoint, bindingKey);
        this.tModelTable.insert(tModelInstances, bindingKey);
    }

    void insert(Binding[] bindings, String serviceKey) throws SQLException {
        String[] inserts = new String[bindings.length];
        int i = 0;
        while (i < bindings.length) {
            String bindingKey = bindings[i].getBindingKey();
            Description[] descriptions = bindings[i].getDescriptions();
            AccessPoint accessPoint = bindings[i].getAccessPoint();
            String hostingRedirector = bindings[i].getHostingRedirector();
            TModelInstance[] tModelInstances = bindings[i].getTModelInstances();
            inserts[i] = "INSERT into binding (BINDING_KEY, SERVICE_KEY, HOSTING_REDIRECTOR) VALUES ('" + bindingKey + "','" + serviceKey + "','" + hostingRedirector + "')";
            this.sqlClient.insert(inserts[i]);
            this.descriptionTable.insert(descriptions, bindingKey);
            this.accessPointTable.insert(accessPoint, bindingKey);
            this.tModelTable.insert(tModelInstances, bindingKey);
            ++i;
        }
    }

    public Object select(Object key) throws SQLException {
        String bindingKey = (String)key;
        return this.selectBinding(bindingKey);
    }

    private Binding selectBinding(String bindingKey) throws SQLException {
        Binding binding = null;
        String query = "SELECT SERVICE_KEY, HOSTING_REDIRECTOR, USER_NAME from binding where BINDING_KEY = '" + bindingKey + "'";
        ResultSet rs = this.sqlClient.select(query);
        if (rs.next()) {
            String serviceKey = rs.getString(1);
            String hostingRedirector = rs.getString(2);
            String userName = rs.getString(3);
            Description[] descriptions = this.descriptionTable.select(bindingKey);
            AccessPoint accessPoint = this.accessPointTable.select(bindingKey);
            TModelInstance[] tModelInstances = this.tModelTable.selectTModels(bindingKey);
            binding = new Binding();
            binding.setBindingKey(bindingKey);
            binding.setServiceKey(serviceKey);
            binding.setHostingRedirector(hostingRedirector);
            binding.setUserName(userName);
            binding.setDescriptions(descriptions);
            binding.setAccessPoint(accessPoint);
            binding.setTModelInstances(tModelInstances);
        }
        return binding;
    }

    Binding[] selectBindings(String serviceKey) throws SQLException {
        Binding[] bindings = new Binding[]{};
        String query = "SELECT BINDING_KEY, HOSTING_REDIRECTOR, USER_NAME from binding where SERVICE_KEY = '" + serviceKey + "'";
        ResultSet rs = this.sqlClient.select(query);
        while (rs.next()) {
            String bindingKey = rs.getString(1);
            String hostingRedirector = rs.getString(2);
            String userName = rs.getString(3);
            Description[] descriptions = this.descriptionTable.select(bindingKey);
            AccessPoint accessPoint = this.accessPointTable.select(bindingKey);
            TModelInstance[] tModelInstances = this.tModelTable.selectTModels(bindingKey);
            Binding binding = new Binding();
            binding.setBindingKey(bindingKey);
            binding.setHostingRedirector(hostingRedirector);
            binding.setUserName(userName);
            binding.setAccessPoint(accessPoint);
            binding.setTModelInstances(tModelInstances);
            binding.setDescriptions(descriptions);
            bindings = (Binding[])ArrayUtil.addElement(bindings, binding);
        }
        return bindings;
    }

    public void delete(Object key) throws SQLException {
        String bindingKey = (String)key;
        String[] stmts = new String[]{"DELETE from binding where BINDING_KEY = '" + bindingKey + "'", "DELETE from description where DESCRIPTION_KEY = '" + bindingKey + "'", "DELETE from access_point where BINDING_KEY = '" + bindingKey + "'"};
        TModelInstance[] tModelInstances = this.tModelTable.selectTModels(bindingKey);
        this.tModelTable.delete(tModelInstances);
        this.sqlClient.execute(stmts);
    }

    void delete(Binding[] bindings) throws SQLException {
        int i = 0;
        while (i < bindings.length) {
            String bindingKey = bindings[i].getBindingKey();
            String[] stmts = new String[]{"DELETE from binding where BINDING_KEY = '" + bindingKey + "'", "DELETE from description where DESCRIPTION_KEY = '" + bindingKey + "'", "DELETE from access_point where BINDING_KEY = '" + bindingKey + "'"};
            TModelInstance[] tModelInstances = bindings[i].getTModelInstances();
            this.tModelTable.delete(tModelInstances);
            this.sqlClient.execute(stmts);
            ++i;
        }
    }

    public void clear() throws SQLException {
        ResultSet rs = this.sqlClient.select("SELECT BINDING_KEY from binding");
        while (rs.next()) {
            this.delete(rs.getString(1));
        }
    }
}

