/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.selectors;

import electric.uddi.Business;
import electric.uddi.Category;
import electric.uddi.IUDDIServer;
import electric.uddi.Service;
import electric.uddi.UDDIException;
import electric.uddi.selectors.ISelector;

public class ServiceCategorySelector
implements ISelector {
    private Category category;

    public ServiceCategorySelector(Category category) {
        this.category = category;
    }

    public boolean selects(IUDDIServer server, Object object) throws UDDIException {
        Business business = (Business)object;
        String[] serviceKeys = server.getServiceKeysForBusiness(business.getBusinessKey());
        int i = 0;
        while (i < serviceKeys.length) {
            Service service = server.readService(serviceKeys[i]);
            if (this.hasCategory(service)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasCategory(Service service) {
        Category[] categories = service.getCategories();
        int i = 0;
        while (i < categories.length) {
            if (this.category.equals(categories[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

