/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.soap.SOAPException;
import electric.uddi.DispositionReport;
import electric.uddi.IUDDIConstants;
import electric.xml.Element;
import electric.xml.IXPath;
import electric.xml.io.literal.LiteralWriter;
import electric.xml.xpath.TMEXPath;
import java.util.Hashtable;

public class UDDIException
extends SOAPException
implements IUDDIConstants {
    private static final IXPath ERRNO_XPATH = new TMEXPath("result/@errno");
    private static final IXPath ERRCODE_XPATH = new TMEXPath("result/errInfo/@errCode");
    private static final IXPath ERRINFO_XPATH = new TMEXPath("result/errInfo");
    private static final Hashtable exceptions = new Hashtable();

    public UDDIException(String message) {
        super(message, "Client", null, UDDIException.getDetail(1));
    }

    public UDDIException(String message, String version) {
        this(message);
        this.setVersion(version);
    }

    public UDDIException(int code) {
        super("Client Error", "Client", null, UDDIException.getDetail(code));
    }

    public UDDIException(int code, String version) {
        this(code);
        this.setVersion(version);
    }

    public UDDIException(Element element) {
        super(element);
        if (this.detail == null || this.getDispositionReport() == null) {
            this.detail = UDDIException.getDetail(1);
        }
    }

    public UDDIException(Element element, String version) {
        this(element);
        this.setVersion(version);
    }

    public UDDIException(Throwable throwable) {
        super(throwable.getMessage(), "Client", null, UDDIException.getDetail(1));
    }

    public UDDIException(Throwable throwable, String version) {
        this(throwable);
        this.setVersion(version);
    }

    public String toString() {
        return "UDDIException( " + this.getErrno() + ": " + this.getErrCode() + ", " + this.getErrInfo() + " )";
    }

    private static Element getDetail(int code) {
        Element detail = new Element("detail");
        try {
            DispositionReport report = new DispositionReport(code);
            LiteralWriter writer = new LiteralWriter(detail);
            report.write(writer);
        }
        catch (Exception exception) {}
        return detail;
    }

    public Element getDispositionReport() {
        return this.detail.getElement("dispositionReport");
    }

    public int getErrno() {
        return Integer.parseInt(this.getDispositionReport().getAttributeValue(ERRNO_XPATH));
    }

    public String getErrCode() {
        return this.getDispositionReport().getAttributeValue(ERRCODE_XPATH);
    }

    public String getErrInfo() {
        return this.getDispositionReport().getTextString(ERRINFO_XPATH);
    }

    public String getOperator() {
        return this.detail.getAttributeValue("operator");
    }

    public void setVersion(String version) {
        Element report = this.getDispositionReport();
        if (report == null) {
            return;
        }
        report.setAttribute("generic", version);
        report.setNamespace("", version.equals("1.0") ? "urn:uddi-org:api" : "urn:uddi-org:api_v2");
    }

    private static void initializeExceptions() {
        UDDIException.addException(1, "E_other", "wraps another exception.");
        UDDIException.addException(30000, "E_assertionNotFound", "signifies that a particular publisher assertion (consisting of two businessKey values, and a keyed reference with three components) cannot be identified in a save or delete operation.");
        UDDIException.addException(10110, "E_authTokenExpired", "signifies that the authentication token information has timed out.");
        UDDIException.addException(10120, "E_authTokenRequired", "signifies that an invalid authentication token was passed to an API call that requires authentication.");
        UDDIException.addException(10160, "E_accountLimitExceeded", "signifies that a save request exceeded the quantity limits for a given structure type.");
        UDDIException.addException(10400, "E_busy", "signifies that the request cannot be processed at the current time.");
        UDDIException.addException(20100, "E_categorizationNotAllowed", "restrictions have been placed by the on the types of information that can categorized within a specific taxonomy. The data provided does not conform to the restrictions placed on the category used. Used with categorization only.");
        UDDIException.addException(10500, "E_fatalError", "signifies that a serious technical error has occurred while processing the request.");
        UDDIException.addException(10210, "E_invalidKeyPassed", "signifies that the uuid_key value passed did not match with any known key values. The details on the invalid key will be included in the dispositionReport structure.");
        UDDIException.addException(20230, "E_invalidProjection", "signifies that an attempt was made to save a businessEntity containing a service projection that does not match the businessService being projected. The serviceKey of at least one such businessService will be included in the dispositionReport.");
        UDDIException.addException(20000, "E_invalidCategory", "signifies that the given keyValue did not correspond to a category within the taxonomy identified by the tModelKey. Used with categorization only.");
        UDDIException.addException(30100, "E_invalidCompletionStatus", "signifies that one of assertion status values passed is unrecognized. The completion status that caused the problem will be clearly indicated in the error text.");
        UDDIException.addException(10220, "E_invalidURLPassed", "signifies that an error occurred during processing of a save function involving accessing data from a remote URL. The details of the HTTP Get report will be included in the dispositionReport structure.");
        UDDIException.addException(20200, "E_invalidValue", "a value that was passed in a keyValue attribute did not pass validation. This applies to checked categorizations, identifiers and other validated code lists. The error text will clearly indicate the key and value combination that failed validation.");
        UDDIException.addException(10310, "E_keyRetired", "signifies that a uuid_key value passed has been removed from the registry. While the key was once valid as an accessor, and is still possibly valid, the publisher has removed the information referenced by the uuid_key passed.");
        UDDIException.addException(10060, "E_languageError", "signifies that an error was detected while processing elements that were annotated with xml:lang qualifiers. Presently, only the description element supports xml:lang qualifiacations.");
        UDDIException.addException(30101, "E_messageTooLarge", "signifies that the message is too large. The upper limit will be clearly indicated in the error text.");
        UDDIException.addException(10020, "E_nameTooLong", "signifies that the partial name value passed exceeds the maximum name length designated by the policy of an implementation or Operator Site.");
        UDDIException.addException(10130, "E_operatorMismatch", "signifies that an attempt was made to use the publishing API to change data that is mastered at another Operator Site. This error is only relevant to the public Operator Sites and does not apply to other UDDI compatible registries.");
        UDDIException.addException(30220, "E_publisherCancelled", "the target publisher cancelled the custody transfer operation.");
        UDDIException.addException(30210, "E_requestDenied", "a custody transfer request has been refused.");
        UDDIException.addException(30230, "E_secretUnknown", "the target publisher was unable to match the shared secret and the five (5) attempt limit was exhausted. The target operator automatically cancelled the transfer operation.");
        UDDIException.addException(0, "E_success", "signifies no failure occurred. This return code is used with the dispositionReport for reporting results from requests with no natural response document.");
        UDDIException.addException(10030, "E_tooManyOptions", "signifies that incompatible arguments were passed.");
        UDDIException.addException(30200, "E_transferAborted", "signifies that a custody transfer request will not succeed.");
        UDDIException.addException(10040, "E_unrecognizedVersion", "signifies that the value of the generic attribute passed is unsupported by the Operator Instance being queried.");
        UDDIException.addException(10150, "E_unknownUser", "signifies that the user ID and password pair passed in a get_authToken message is not known to the Operator Site or is not valid.");
        UDDIException.addException(10050, "E_unsupported", "signifies that the implementor does not support a feature or API.");
        UDDIException.addException(10140, "E_userMismatch", "signifies that an attempt was made to use the publishing API to change data that is controlled by another party. In certain cases, E_operatorMismatch takes precedence in reporting an error.");
        UDDIException.addException(20210, "E_valueNotAllowed", "signifies that a value did not pass validation because of contextual issues. The value may be valid in some contexts, but not in the context used. The error text may contain information about the contextual problem.");
    }

    private static void addException(int code, String name, String description) {
        exceptions.put(new Integer(code), new String[]{name, description});
    }

    public static String getExceptionName(int code) {
        return ((String[])exceptions.get(new Integer(code)))[0];
    }

    public static String getExceptionDescription(int code) {
        return ((String[])exceptions.get(new Integer(code)))[1];
    }

    static {
        UDDIException.initializeExceptions();
    }
}

