/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.IUDDIConstants;
import electric.uddi.Name;
import electric.uddi.Service;
import electric.util.named.INamed;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralWriter;
import java.io.IOException;

public final class ServiceInfo
implements ISerializable,
INamed,
IUDDIConstants {
    private String businessKey = "";
    private String serviceKey = "";
    private Name[] names = new Name[0];

    public ServiceInfo() {
    }

    public ServiceInfo(Service service) {
        this.businessKey = service.getBusinessKey();
        this.serviceKey = service.getServiceKey();
        this.names = service.getNames();
    }

    public String toString() {
        try {
            LiteralWriter writer = new LiteralWriter(new Element("ServiceInfo"));
            this.write(writer);
            return writer.getElement().toString();
        }
        catch (IOException exception) {
            return exception.toString();
        }
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public String getName() {
        return this.names.length == 0 ? null : this.names[0].getText();
    }

    public Name[] getNames() {
        return this.names;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void write(IWriter writer) throws IOException {
        IWriter entity = writer.writeElement("serviceInfo");
        entity.writeAttribute("serviceKey", this.serviceKey);
        entity.writeAttribute("businessKey", this.businessKey);
        Name.writeList(entity, this.names);
    }

    public void read(IReader reader) throws IOException {
        this.serviceKey = reader.readAttributeValue("serviceKey");
        this.businessKey = reader.readAttributeValue("businessKey");
        this.names = Name.readList(reader);
    }
}

