/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.IUDDIConstants;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class Qualifier
implements ISerializable,
IUDDIConstants {
    public static final Qualifier DEFAULT = new Qualifier();
    private boolean exactNameMatch = false;
    private boolean caseSensitiveMatch = false;
    private boolean combineCategoryBags = false;
    private boolean serviceSubset = false;
    private boolean soundexNameMatch = false;
    private int nameSortDirection = 0;
    private int dateSortDirection = 0;
    private int comparisonStrategy = 0;
    private int maxRows = Integer.MAX_VALUE;

    public String toString() {
        return "Qualifier( exact-name=" + this.exactNameMatch + ", case-sensitive=" + this.caseSensitiveMatch + ", bag-combination-strategy=" + IUDDIConstants.comparisonStrategies[this.comparisonStrategy] + ", combine-category-bags=" + this.combineCategoryBags + ", serviceSubset=" + this.serviceSubset + ", soundex-name-match=" + this.soundexNameMatch + ", name-sort=" + IUDDIConstants.directions[this.nameSortDirection] + ", date-sort=" + IUDDIConstants.directions[this.dateSortDirection] + ", max-rows=" + this.maxRows + " )";
    }

    public boolean isDefault() {
        if (this.exactNameMatch) {
            return false;
        }
        if (this.caseSensitiveMatch) {
            return false;
        }
        if (this.combineCategoryBags) {
            return false;
        }
        if (this.serviceSubset) {
            return false;
        }
        if (this.soundexNameMatch) {
            return false;
        }
        if (this.nameSortDirection != 0) {
            return false;
        }
        if (this.dateSortDirection != 0) {
            return false;
        }
        if (this.comparisonStrategy != 0) {
            return false;
        }
        return this.maxRows == Integer.MAX_VALUE;
    }

    public void setExactNameMatch(boolean flag) {
        this.exactNameMatch = flag;
    }

    public boolean getExactNameMatch() {
        return this.exactNameMatch;
    }

    public void setCaseSensitiveMatch(boolean flag) {
        this.caseSensitiveMatch = flag;
    }

    public boolean getCaseSensitiveMatch() {
        return this.caseSensitiveMatch;
    }

    public void setSoundexNameMatch(boolean flag) {
        this.soundexNameMatch = flag;
    }

    public boolean getSoundexNameMatch() {
        return this.soundexNameMatch;
    }

    public void setComparisonStrategy(int strategy) {
        this.comparisonStrategy = strategy;
    }

    public int getComparisonStrategy() {
        return this.comparisonStrategy;
    }

    public void setCombineCategoryBags(boolean flag) {
        this.combineCategoryBags = flag;
    }

    public boolean getCombineCategoryBags() {
        return this.combineCategoryBags;
    }

    public void setServiceSubset(boolean flag) {
        this.serviceSubset = flag;
    }

    public boolean getServiceSubset() {
        return this.serviceSubset;
    }

    public void setNameSortDirection(int direction) {
        this.nameSortDirection = direction;
    }

    public int getNameSortDirection() {
        return this.nameSortDirection;
    }

    public void setDateSortDirection(int dateSortDirection) {
        this.dateSortDirection = dateSortDirection;
    }

    public int getDateSortDirection() {
        return this.dateSortDirection;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void write(IWriter writer) throws IOException {
        if (this.maxRows != Integer.MAX_VALUE) {
            writer.writeAttribute("maxRows", Integer.toString(this.maxRows));
        }
        if (this.isDefault()) {
            return;
        }
        IWriter qualifiers = writer.writeElement("findQualifiers");
        if (this.exactNameMatch) {
            qualifiers.writeString("findQualifier", "exactNameMatch");
        }
        if (this.caseSensitiveMatch) {
            qualifiers.writeString("findQualifier", "caseSensitiveMatch");
        }
        if (this.soundexNameMatch) {
            qualifiers.writeString("findQualifier", "soundexMatch");
        }
        if (this.comparisonStrategy == 3) {
            qualifiers.writeString("findQualifier", "orAllKeys");
        } else if (this.comparisonStrategy == 2) {
            qualifiers.writeString("findQualifier", "orLikeKeys");
        } else if (this.comparisonStrategy == 1) {
            qualifiers.writeString("findQualifier", "andAllKeys");
        }
        if (this.combineCategoryBags) {
            qualifiers.writeString("findQualifier", "combineCategoryBags");
        }
        if (this.serviceSubset) {
            qualifiers.writeString("findQualifier", "serviceSubset");
        }
        if (this.nameSortDirection == 1) {
            qualifiers.writeString("findQualifier", "sortByNameAsc");
        } else if (this.nameSortDirection == 2) {
            qualifiers.writeString("findQualifier", "sortByNameDesc");
        }
        if (this.dateSortDirection == 1) {
            qualifiers.writeString("findQualifier", "sortByDateAsc");
        } else if (this.dateSortDirection == 2) {
            qualifiers.writeString("findQualifier", "sortByDateDesc");
        }
    }

    public void read(IReader reader) throws IOException {
        Element qualifiers;
        String rows = reader.readAttributeValue("maxRows");
        if (rows != null) {
            this.maxRows = Integer.parseInt(rows);
        }
        if ((qualifiers = reader.readElement("findQualifiers")) == null) {
            return;
        }
        Elements elements = qualifiers.getElements("findQualifier");
        while (elements.hasMoreElements()) {
            String text = elements.next().getString();
            if (text.equals("exactNameMatch")) {
                this.exactNameMatch = true;
                continue;
            }
            if (text.equals("caseSensitiveMatch")) {
                this.caseSensitiveMatch = true;
                continue;
            }
            if (text.equals("soundexMatch")) {
                this.soundexNameMatch = true;
                continue;
            }
            if (text.equals("andAllKeys")) {
                this.comparisonStrategy = 1;
                continue;
            }
            if (text.equals("orLikeKeys")) {
                this.comparisonStrategy = 2;
                continue;
            }
            if (text.equals("orAllKeys")) {
                this.comparisonStrategy = 3;
                continue;
            }
            if (text.equals("combineCategoryBags")) {
                this.combineCategoryBags = true;
                continue;
            }
            if (text.equals("serviceSubset")) {
                this.serviceSubset = true;
                continue;
            }
            if (text.equals("sortByNameAsc")) {
                this.nameSortDirection = 1;
                continue;
            }
            if (text.equals("sortByNameDesc")) {
                this.nameSortDirection = 2;
                continue;
            }
            if (text.equals("sortByDateAsc")) {
                this.dateSortDirection = 1;
                continue;
            }
            if (!text.equals("sortByDateDesc")) continue;
            this.dateSortDirection = 2;
        }
    }

    public static boolean hasQualifier(Element xml) {
        return xml.getAttribute("maxRows") != null || xml.getElement("findQualifiers") != null;
    }

    public static Qualifier readQualifier(IReader reader) throws IOException {
        if (!Qualifier.hasQualifier(reader.getElement())) {
            return DEFAULT;
        }
        Qualifier qualifier = new Qualifier();
        qualifier.read(reader);
        return qualifier;
    }
}

