/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Assertion;
import electric.uddi.AssertionStatus;
import electric.uddi.AssertionStatusReport;
import electric.uddi.Authorization;
import electric.uddi.Business;
import electric.uddi.IPublicationCommand;
import electric.uddi.ISubscriptionFilter;
import electric.uddi.IUDDIServer;
import electric.uddi.UDDIException;
import electric.uddi.admin.User;
import electric.uddi.selectors.AssertionSelector;
import electric.uddi.util.UDDIUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public final class GetAssertionStatusReport
implements IPublicationCommand,
ISubscriptionFilter {
    private String status;

    public GetAssertionStatusReport() {
    }

    public GetAssertionStatusReport(String status) {
        this.status = status;
    }

    public String toString() {
        return UDDIUtil.toString(this);
    }

    public String getVersion() {
        return "2.0";
    }

    public boolean needsAuthorization() {
        return true;
    }

    public Object invoke(IUDDIServer server, Authorization authorization) throws UDDIException {
        if (!AssertionStatus.isValidStatus(this.status)) {
            throw new UDDIException(30100);
        }
        User user = server.getPublisher(authorization);
        Business[] businesses = server.getBusinessesForUser(user);
        String[] businessKeys = new String[businesses.length];
        int i = 0;
        while (i < businesses.length) {
            businessKeys[i] = businesses[i].getBusinessKey();
            ++i;
        }
        AssertionSelector selector = new AssertionSelector(this.status, businessKeys, null);
        Vector<AssertionStatus> list = new Vector<AssertionStatus>();
        Enumeration enumeration = server.getAssertions();
        while (enumeration.hasMoreElements()) {
            Assertion assertion = (Assertion)enumeration.nextElement();
            if (!selector.selects(server, assertion)) continue;
            list.addElement(new AssertionStatus(server, assertion.getStatus(), assertion, user));
        }
        AssertionStatusReport statusReport = new AssertionStatusReport();
        statusReport.list = new AssertionStatus[list.size()];
        list.copyInto(statusReport.list);
        return statusReport;
    }

    public void write(IWriter writer) throws IOException {
        IWriter query = writer.writeElement("get_assertionStatusReport");
        if (this.status != null) {
            query.writeString("completionStatus", this.status);
        }
    }

    public void read(IReader reader) throws IOException {
        this.status = reader.readString("completionStatus");
    }
}

