/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.IUDDIConstants;
import electric.util.array.ArrayUtil;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import java.io.IOException;

public final class Description
implements ISerializable,
IUDDIConstants {
    private String text;
    private String language;

    public Description() {
        this.text = "";
    }

    public Description(String text) {
        this.text = text;
    }

    public Description(String text, String language) {
        this.text = text;
        this.language = language;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.language != null) {
            buffer.append("(xml:lang=");
            buffer.append(this.language);
            buffer.append(") ");
        }
        buffer.append(this.text);
        return buffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Description)) {
            return false;
        }
        Description description = (Description)object;
        if (!ArrayUtil.equals(this.language, description.language)) {
            return false;
        }
        return ArrayUtil.equals(this.text, description.text);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean hasLanguage() {
        return this.language != null;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void write(IWriter writer) throws IOException {
        IWriter description = writer.writeElement("description");
        if (this.language != null) {
            description.writeAttribute("xml:lang", this.language);
        }
        description.writeString(this.text);
    }

    public void read(IReader reader) throws IOException {
        this.text = reader.readString();
        this.language = reader.readAttributeValue("lang");
    }

    public static Description[] readList(IReader reader) throws IOException {
        IReader[] readers = reader.getReaders("description");
        Description[] descriptions = new Description[readers.length];
        int i = 0;
        while (i < descriptions.length) {
            descriptions[i] = new Description();
            descriptions[i].read(readers[i]);
            ++i;
        }
        return descriptions;
    }

    public static void writeList(IWriter writer, Description[] descriptions) throws IOException {
        int i = 0;
        while (i < descriptions.length) {
            descriptions[i].write(writer);
            ++i;
        }
    }
}

