/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi;

import electric.uddi.Business;
import electric.uddi.Description;
import electric.uddi.IUDDIConstants;
import electric.uddi.Name;
import electric.uddi.ServiceInfo;
import electric.uddi.util.UDDIUtil;
import electric.util.named.INamed;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralWriter;
import java.io.IOException;

public final class BusinessInfo
implements ISerializable,
INamed,
IUDDIConstants {
    private String businessKey = "";
    private Name[] names = new Name[0];
    private Description[] descriptions = new Description[0];
    private ServiceInfo[] serviceInfos = new ServiceInfo[0];
    static /* synthetic */ Class class$electric$uddi$ServiceInfo;

    public BusinessInfo() {
    }

    public BusinessInfo(Business business, ServiceInfo[] serviceInfos) {
        this.businessKey = business.getBusinessKey();
        this.names = business.getNames();
        this.descriptions = business.getDescriptions();
        this.serviceInfos = serviceInfos;
    }

    public String toString() {
        try {
            LiteralWriter writer = new LiteralWriter(new Element("BusinessInfo"));
            this.write(writer);
            return writer.getElement().toString();
        }
        catch (IOException exception) {
            return exception.toString();
        }
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public Name[] getNames() {
        return this.names;
    }

    public String getName() {
        return this.names.length == 0 ? null : this.names[0].getText();
    }

    public Description[] getDescriptions() {
        return this.descriptions;
    }

    public ServiceInfo[] getServiceInfos() {
        return this.serviceInfos;
    }

    public ServiceInfo getServiceInfo(String serviceKey) {
        int i = 0;
        while (i < this.serviceInfos.length) {
            if (serviceKey.equals(this.serviceInfos[i].getServiceKey())) {
                return this.serviceInfos[i];
            }
            ++i;
        }
        return null;
    }

    public void write(IWriter writer) throws IOException {
        IWriter businessInfo = writer.writeElement("businessInfo");
        businessInfo.writeAttribute("businessKey", this.businessKey);
        Name.writeList(businessInfo, this.names);
        Description.writeList(businessInfo, this.descriptions);
        if (this.serviceInfos.length > 0) {
            UDDIUtil.writeList(businessInfo, "serviceInfos", this.serviceInfos);
        }
    }

    public void read(IReader reader) throws IOException {
        this.businessKey = reader.readAttributeValue("businessKey");
        this.names = Name.readList(reader);
        this.descriptions = Description.readList(reader);
        this.serviceInfos = (ServiceInfo[])UDDIUtil.readList(reader.getReader("serviceInfos"), class$electric$uddi$ServiceInfo == null ? (class$electric$uddi$ServiceInfo = BusinessInfo.class$("electric.uddi.ServiceInfo")) : class$electric$uddi$ServiceInfo);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

