/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl;

import electric.soap.wsdl.DocLitSOAPWriter;
import electric.soap.wsdl.ISOAPWriter;
import electric.soap.wsdl.RPCLitSOAPWriter;
import electric.soap.wsdl.RPCSOAPWriter;
import electric.soap.wsdl.SOAPOperation;
import electric.wsdl.IWSDLConstants;
import electric.xml.Element;
import electric.xml.io.schema.SchemaException;

public class SOAPWriterFactory
implements IWSDLConstants {
    public static ISOAPWriter getWriter(SOAPOperation operation, Element operationElement) throws SchemaException {
        String encodingStyle = operation.getBinding().getWSDL().getEncodingStyle();
        String style = operationElement.getAttribute("style");
        String use = null;
        if (operation.getInput() != null) {
            Element inputElement = operationElement.getElement("input");
            Element body = inputElement.getElement("body");
            if (body != null) {
                use = body.getAttribute("use");
                encodingStyle = body.getAttribute("encodingStyle");
            }
            if (style == null) {
                style = operation.getBinding().getStyle();
            }
            if (use == null) {
                use = SOAPWriterFactory.getDefaultUse(style);
            }
        }
        return SOAPWriterFactory.getWriter(operation, style, use, encodingStyle);
    }

    public static ISOAPWriter getWriter(SOAPOperation operation, String style, String use, String encodingStyle) throws SchemaException {
        if ("rpc".equalsIgnoreCase(style)) {
            if ("literal".equalsIgnoreCase(use)) {
                return new RPCLitSOAPWriter(operation);
            }
            return new RPCSOAPWriter(operation, encodingStyle);
        }
        if ("literal".equalsIgnoreCase(use)) {
            return new DocLitSOAPWriter(operation);
        }
        throw new SchemaException("GLUE does not handle document/encoded web services.");
    }

    private static String getDefaultUse(String style) {
        if ("rpc".equalsIgnoreCase(style)) {
            return "encoded";
        }
        return "literal";
    }
}

