/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl;

import electric.util.XURL;
import electric.wsdl.Binding;
import electric.wsdl.Port;
import electric.wsdl.Service;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.io.schema.SchemaException;

public final class SOAPPort
extends Port {
    private String wsdlSOAPNamespace;

    public SOAPPort(Service service, Element port) throws WSDLException, SchemaException {
        super(service, port);
        Element address = port.getElement("address");
        if (address == null) {
            throw new WSDLException("SOAP <port> is missing address attribute");
        }
        String location = address.getAttributeValue("location");
        if (location == null) {
            throw new WSDLException("SOAP <port> is missing location attribute");
        }
        try {
            this.setEndpoint(location);
        }
        catch (Exception exception) {
            throw new WSDLException(exception.toString());
        }
    }

    public SOAPPort(Service service, Binding binding, String name, XURL endpoint, String wsdlSOAPNamespace) {
        super(service, binding, name, endpoint);
        this.wsdlSOAPNamespace = wsdlSOAPNamespace;
    }

    public Element writeWSDL(Element service) {
        Element port = super.writeWSDL(service);
        String prefix = service.getPrefix(this.wsdlSOAPNamespace, "soap");
        Element soapAddress = port.addElement(prefix, "address");
        soapAddress.setAttribute("location", this.endpoint.toString());
        return port;
    }
}

