/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl;

import electric.soap.ISOAPConstants;
import electric.soap.wsdl.util.WSDLUtil;
import electric.util.array.ArrayUtil;
import electric.util.dime.IDIMEConstants;
import electric.util.mime.IMIMEConstants;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.MessageDecl;
import electric.wsdl.Part;
import electric.wsdl.WSDLException;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.Type;
import electric.xml.io.mime.MIMEType;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.util.TypeUtil;

public class SOAPMessageDecl
implements ISOAPConstants,
ISchemaConstants,
IWSDLConstants,
IDIMEConstants,
IMIMEConstants {
    private static String defaultAttachmentStyle = "mime";
    public MessageDecl messageDecl;
    public String namespace;
    private String use;
    private String type;
    private boolean literal;
    private String encodingStyle;
    private String attachmentStyle = defaultAttachmentStyle;
    private String messageDeclNamespace;

    public SOAPMessageDecl(String namespace, boolean literal) {
        this.namespace = namespace;
        this.literal = literal;
    }

    public SOAPMessageDecl(MessageDecl messageDecl, String namespace, String use, String encodingStyle, String type, String messageDeclNamespace) {
        this.messageDecl = messageDecl;
        this.namespace = namespace;
        this.use = use;
        this.encodingStyle = encodingStyle;
        this.type = type;
        this.literal = "literal".equalsIgnoreCase(use);
        this.messageDeclNamespace = messageDeclNamespace;
    }

    public SOAPMessageDecl(Element root, MessageDecl messageDecl, String type) throws WSDLException {
        this.messageDecl = messageDecl;
        this.type = type;
        this.parseSOAPBody(root);
        this.literal = "literal".equalsIgnoreCase(this.use);
    }

    private void parseSOAPBody(Element root) throws WSDLException {
        Element soapBody = root.getElement("body");
        if (root.getElement("http://schemas.xmlsoap.org/ws/2002/04/dime/wsdl/", "message") != null && soapBody != null) {
            this.setAttachmentStyle("dime");
            this.parseDime();
            this.use = soapBody.getAttributeValue("use");
            this.encodingStyle = soapBody.getAttributeValue("encodingStyle");
            this.namespace = soapBody.getAttributeValue("namespace");
        } else if (soapBody != null) {
            this.use = soapBody.getAttributeValue("use");
            this.encodingStyle = soapBody.getAttributeValue("encodingStyle");
            this.namespace = soapBody.getAttributeValue("namespace");
        } else if (root.getElement("multipartRelated") != null) {
            this.setAttachmentStyle("mime");
            this.parseMultipart(root.getElement("multipartRelated"));
        } else if (root.getElement("content") != null) {
            this.parseMimeContents(root.getElements("content"));
        }
        if (this.namespace == null) {
            this.namespace = this.messageDecl.getMessage().getWSDL().getTargetNamespace();
        }
    }

    private void parseDime() throws WSDLException {
        try {
            Part[] parts = this.messageDecl.getMessage().getParts();
            int i = 0;
            while (i < parts.length) {
                Part part = parts[i];
                Type baseSimpleType = TypeUtil.getBaseSimpleType(part.getType());
                if (baseSimpleType != null && WSDLUtil.isBinaryType(baseSimpleType)) {
                    MIMEType type = (MIMEType)this.messageDecl.getMessage().getWSDL().getType("http://mime/:data");
                    part.setType(type);
                }
                ++i;
            }
        }
        catch (SchemaException exception) {
            throw new WSDLException("problem processing dime wsdl", exception);
        }
    }

    private void parseMimeContents(Elements contentElements) throws WSDLException {
        Object[] contentTypes = new String[]{};
        String partName = null;
        while (contentElements.hasMoreElements()) {
            Element contentElement = contentElements.next();
            String contentPartName = contentElement.getAttributeValue("part");
            if (partName == null) {
                partName = contentPartName;
            } else if (partName != null && !partName.equals(contentPartName)) {
                throw new WSDLException("alternative mime:content elements must point to the same message part");
            }
            String contentType = contentElement.getAttributeValue("type");
            String string = contentType = contentType == null ? "*/*" : contentType;
            if (ArrayUtil.indexOf(contentType, contentTypes) != -1) continue;
            contentTypes = (String[])ArrayUtil.addElement(contentTypes, contentType);
        }
        if (partName == null && this.messageDecl.getMessage().getPartCount() > 1) {
            throw new WSDLException("mime:content element must have part attribute when more than one message part available");
        }
        Part part = partName == null ? this.messageDecl.getMessage().getPart(0) : this.messageDecl.getMessage().getPart(partName);
        try {
            MIMEType type = (MIMEType)this.messageDecl.getMessage().getWSDL().getType("http://mime/:data");
            part.setType(type);
            type.setContentTypes((String[])contentTypes);
        }
        catch (SchemaException exception) {
            exception.printStackTrace();
        }
    }

    private void parseMultipart(Element multipart) throws WSDLException {
        Elements elements = multipart.getElements("part");
        while (elements.hasMoreElements()) {
            this.parsePart(elements.next());
        }
    }

    private void parsePart(Element part) throws WSDLException {
        if (part.getElement("body") != null) {
            this.parseSOAPBody(part);
        } else {
            Elements contentElements = part.getElements("content");
            if (contentElements.hasMoreElements()) {
                this.parseMimeContents(contentElements);
            }
        }
    }

    void writeWSDL(Element operation) {
        if (this.messageDecl.isVoid()) {
            return;
        }
        String wsdlPrefix = operation.getNamespacePrefix("http://schemas.xmlsoap.org/wsdl/");
        Element element = operation.addElement(wsdlPrefix, this.type);
        element.setAttribute("name", this.messageDecl.getName());
        Part[] mimeParts = this.getMimeParts();
        if (mimeParts.length == 0) {
            this.writeSoapBody(element);
        } else if ("mime".equals(this.attachmentStyle)) {
            this.writeMultiPart(element, mimeParts);
        } else {
            this.writeDime(element);
        }
    }

    private void writeSoapBody(Element element) {
        Element body;
        String prefix = element.getPrefix(this.messageDeclNamespace, "soap");
        if (!this.messageDecl.getType().equals("fault")) {
            body = element.addElement(prefix, "body");
        } else {
            body = element.addElement(prefix, "fault");
            String soapFaultName = this.messageDecl.getName();
            body.setAttribute("name", soapFaultName);
        }
        body.setAttribute("use", this.use);
        if (this.namespace != null) {
            body.setAttribute("namespace", this.namespace);
        }
        if (this.use.equalsIgnoreCase("encoded")) {
            body.setAttribute("encodingStyle", this.encodingStyle);
        }
    }

    private void writeDime(Element element) {
        String dimePrefix = element.getPrefix("http://schemas.xmlsoap.org/ws/2002/04/dime/wsdl/", "dime");
        Element dimeElement = element.addElement(dimePrefix, "message");
        dimeElement.setAttribute("layout", "http://schemas.xmlsoap.org/ws/2002/04/dime/closed-layout");
        dimeElement.setAttribute("wsdl", "required", "true");
        this.writeSoapBody(element);
    }

    private Part[] getMimeParts() {
        Part[] mimeParts = new Part[]{};
        int i = 0;
        while (i < this.messageDecl.getMessage().getPartCount()) {
            if (this.messageDecl.getMessage().getPart(i).getType() instanceof MIMEType) {
                mimeParts = (Part[])ArrayUtil.addElement(mimeParts, this.messageDecl.getMessage().getPart(i));
            }
            ++i;
        }
        return mimeParts;
    }

    private void writeMultiPart(Element element, Part[] mimeParts) {
        Element multipartElement = element.addElement("mime", "multipartRelated");
        this.writeSoapBody(multipartElement.addElement("mime", "part"));
        int i = 0;
        while (i < mimeParts.length) {
            this.writePart(multipartElement, mimeParts[i]);
            ++i;
        }
    }

    private void writePart(Element multipartElement, Part mimePart) {
        Element mimePartElement = multipartElement.addElement("mime", "part");
        String[] contentTypes = ((MIMEType)mimePart.getType()).getContentTypes();
        int i = 0;
        while (i < contentTypes.length) {
            Element mimeContent = mimePartElement.addElement("mime", "content");
            mimeContent.setAttribute("part", mimePart.getName());
            mimeContent.setAttribute("type", contentTypes[i]);
            ++i;
        }
    }

    public String getAttachmentStyle() {
        return this.attachmentStyle;
    }

    public void setAttachmentStyle(String attachmentStyle) {
        if (attachmentStyle == null) {
            attachmentStyle = "mime";
        }
        this.attachmentStyle = attachmentStyle;
    }

    public static void setDefaultAttachmentStyle(String style) {
        defaultAttachmentStyle = style;
    }

    public String getDefaultAttachmentStyle() {
        return defaultAttachmentStyle;
    }
}

