/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.wsdl;

import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.soap.rpc.In;
import electric.soap.rpc.InOut;
import electric.soap.rpc.Out;
import electric.soap.rpc.Parameter;
import electric.soap.rpc.Return;
import electric.soap.util.SOAPEnvelopes;
import electric.soap.wsdl.ISOAPWriter;
import electric.soap.wsdl.SOAPOperation;
import electric.wsdl.IWSDLConstants;
import electric.wsdl.Part;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.complex.ComplexType;
import electric.xml.io.literal.LiteralReader;
import electric.xml.io.literal.LiteralWriter;
import electric.xml.io.model.All;
import electric.xml.io.model.IModel;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;

public class DocLitSOAPWriter
implements ISOAPWriter,
IWSDLConstants {
    protected static final String SMALL_PREFIX = "n";
    private boolean bare;
    private SOAPOperation operation;
    private String requestName;
    private String responseName;

    public DocLitSOAPWriter(SOAPOperation operation) throws SchemaException {
        this.operation = operation;
        this.setParameters();
    }

    public IReader getReader(SOAPMessage message) {
        return new LiteralReader(message.getBody().getFirstElement(), this.operation.getNamespaces());
    }

    public IWriter getResponseWriter(SOAPMessage response) {
        if (this.responseName != null) {
            Element reply = response.getBody().addElement();
            this.setWrappedName(reply, this.responseName, this.operation.getOutput().messageDecl.getMessage().getPart(0).getType());
            return new LiteralWriter(reply, this.operation.getNamespaces(), !response.getOptimizations().getTypeOmission());
        }
        Element body = response.getBody();
        body.setNamespace("", this.operation.getReturnValue().getNamespace());
        return new LiteralWriter(body, this.operation.getNamespaces(), !response.getOptimizations().getTypeOmission());
    }

    public IWriter getRequestWriter(SOAPMessage request) {
        if (this.bare) {
            return new LiteralWriter(request.getBody(), this.operation.getNamespaces(), !request.getOptimizations().getTypeOmission());
        }
        Element call = request.getBody().addElement();
        this.setWrappedName(call, this.requestName, this.operation.getOperation().getInput().getMessage().getPart(0).getType());
        return new LiteralWriter(call, this.operation.getNamespaces(), !request.getOptimizations().getTypeOmission());
    }

    private void setWrappedName(Element call, String messageName, Type anonymousType) {
        boolean qualify = anonymousType.getSchema().getQualifyElements();
        if (qualify) {
            String namespace = anonymousType.getNamespace();
            call.setNamespace(SMALL_PREFIX, namespace);
            call.setName(SMALL_PREFIX, messageName);
        } else {
            call.setName(messageName);
        }
    }

    public SOAPOptimizations selectOptimizations(SOAPOptimizations optimizations) {
        if (this.operation.isPolymorphic() || !optimizations.getTypeOmission()) {
            return SOAPOptimizations.NONE;
        }
        return SOAPOptimizations.DEFAULT;
    }

    public boolean isRPC() {
        return false;
    }

    public void writeStyle(Element soapOperation) {
        soapOperation.setAttribute("style", "document");
    }

    public void setDocument(SOAPMessage request, SOAPOptimizations optimizations) {
        request.setDocument(SOAPEnvelopes.newLiteralEnvelope(this.operation.getVersion()), optimizations);
    }

    public void setParameters() throws SchemaException {
        try {
            Part[] inputParts = this.operation.getOperation().getInput().getMessage().getParts();
            Part[] outputParts = this.operation.getOperation().getOutput().getMessage().getParts();
            this.setInputs(inputParts);
            this.setOutputs(outputParts);
        }
        catch (SchemaException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void setOutputs(Part[] outputParts) throws SchemaException {
        Type outputType;
        if (outputParts.length == 1 && (outputType = outputParts[0].getImplicitType()) instanceof ComplexType && outputType.isAnonymous()) {
            SchemaElement outputElement = outputParts[0].getSchemaElement();
            this.setWrappedOutputs(outputType, outputElement);
            return;
        }
        this.setBareOutputs(outputParts);
    }

    private void setBareOutputs(Part[] outputParts) throws SchemaException {
        int i = 0;
        while (i < outputParts.length) {
            if (!this.processInOut(outputParts[i].getName())) {
                SchemaElement element = this.getElement(outputParts[i]);
                element.setBare(true);
                if (this.operation.getReturnValue() == null) {
                    this.operation.setReturnValue(new Return(element));
                } else {
                    this.operation.addParameter(new Out(element));
                }
            }
            ++i;
        }
    }

    private void setWrappedOutputs(Type outputType, SchemaElement outputElement) throws SchemaException {
        ComplexType complexType = (ComplexType)outputType;
        complexType.getSchema().removeSchemaType(complexType);
        this.responseName = outputElement.getName();
        if (complexType.getModel() != null) {
            SchemaElement[] elements = ((All)complexType.getModel()).getElements();
            if (elements.length == 0) {
                return;
            }
            int i = 0;
            while (i < elements.length) {
                if (!this.processInOut(elements[i].getName())) {
                    elements[i].setDisableTypeOmission(!SOAPOptimizations.isTypeOmissionEnabled());
                    elements[i].setBare(false);
                    if (this.operation.getReturnValue() == null) {
                        this.operation.setReturnValue(new Return(elements[i]));
                    } else {
                        this.operation.addParameter(new Out(elements[i]));
                    }
                }
                ++i;
            }
        }
    }

    private boolean processInOut(String name) throws SchemaException {
        int j = 0;
        while (j < this.operation.parameters.length) {
            if (this.operation.parameters[j].getName().equals(name)) {
                In in = (In)this.operation.parameters[j];
                this.operation.parameters[j] = new InOut(in.getSchemaElement(), in.requestIndex);
                return true;
            }
            ++j;
        }
        return false;
    }

    private void setInputs(Part[] inputParts) throws SchemaException {
        Type inputType;
        if (inputParts.length == 1 && (inputType = inputParts[0].getImplicitType()) instanceof ComplexType && inputType.isAnonymous()) {
            SchemaElement inputElement = inputParts[0].getSchemaElement();
            this.setWrappedInputs(inputElement);
            return;
        }
        this.setBareInputs(inputParts);
    }

    private void setBareInputs(Part[] inputParts) throws SchemaException {
        this.operation.parameters = new Parameter[0];
        this.bare = true;
        int i = 0;
        while (i < inputParts.length) {
            SchemaElement element = this.getElement(inputParts[i]);
            element.setDisableTypeOmission(!SOAPOptimizations.isTypeOmissionEnabled());
            element.setBare(this.bare);
            this.operation.addParameter(new In(element, i + 1));
            ++i;
        }
    }

    private void setWrappedInputs(SchemaElement inputElement) throws SchemaException {
        this.requestName = inputElement.getName();
        ComplexType complexType = (ComplexType)inputElement.getType();
        complexType.getSchema().removeSchemaType(complexType);
        IModel model = complexType.getModel();
        if (model != null) {
            SchemaElement[] elements = ((All)model).getElements();
            this.operation.parameters = new Parameter[elements.length];
            int i = 0;
            while (i < this.operation.parameters.length) {
                elements[i].setBare(false);
                this.operation.parameters[i] = new In(elements[i], i + 1);
                ++i;
            }
        } else {
            this.operation.parameters = new Parameter[0];
        }
    }

    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public String getResponseName() {
        return this.responseName;
    }

    public void setResponseName(String responseName) {
        this.responseName = responseName;
    }

    private final SchemaElement getElement(Part inputPart) throws SchemaException {
        All all;
        SchemaElement[] elements;
        ComplexType complexType;
        SchemaElement element = inputPart.getSchemaElement();
        if (element != null) {
            return element;
        }
        Type inputType = inputPart.getType();
        if (inputType instanceof ComplexType && (complexType = (ComplexType)inputType).getModel() instanceof All && (elements = (all = (All)complexType.getModel()).getElements()).length == 1) {
            return elements[0];
        }
        element = new SchemaElement(inputPart.getName(), inputType, false);
        return element;
    }
}

