/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.util;

import electric.soap.SOAPMessage;
import electric.soap.rpc.Parameter;
import electric.util.Value;
import electric.util.mime.MIMEData;
import electric.xml.io.IReader;
import electric.xml.io.mime.MIMEType;
import electric.xml.io.schema.SchemaException;
import java.rmi.MarshalException;

public final class SOAPAttachments {
    public static void registerAttachments(SOAPMessage message, IReader reader) {
        MIMEData[] attachments = message.getAttachments();
        int i = 0;
        while (i < attachments.length) {
            MIMEData attachment = attachments[i];
            if (attachment.getContentId() != null) {
                reader.addObject(attachment.getContentId(), attachment);
            }
            if (attachment.getContentId() != null) {
                reader.addObject("cid:" + attachment.getContentId(), attachment);
            }
            reader.addObject(attachment.getContentLabel(), attachment);
            ++i;
        }
    }

    public static void addRequestAttachments(SOAPMessage request, Parameter[] parameters, Object[] args) throws MarshalException {
        int i = 0;
        while (i < parameters.length) {
            try {
                if (parameters[i].getType() instanceof MIMEType && parameters[i].isInput()) {
                    request.addAttachment((MIMEData)parameters[i].getRawObject(args[i]));
                }
            }
            catch (SchemaException exception) {
                throw new MarshalException(exception.toString());
            }
            ++i;
        }
    }

    public static void addResponseAttachments(SOAPMessage response, Parameter[] parameters, Parameter returnValue, Object[] args, Value result) throws MarshalException {
        try {
            int i = 0;
            while (i < parameters.length) {
                if (parameters[i].getType() instanceof MIMEType && parameters[i].isOutput()) {
                    response.addAttachment((MIMEData)parameters[i].getRawObject(args[i]));
                }
                ++i;
            }
            if (returnValue != null && returnValue.getType() instanceof MIMEType) {
                response.addAttachment((MIMEData)result.getObject());
            }
        }
        catch (SchemaException exception) {
            throw new MarshalException(exception.toString());
        }
    }
}

