/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.util;

import electric.soap.ISOAPConstants;
import electric.soap.security.signature.xml.ElementReference;
import electric.xml.Children;
import electric.xml.Element;
import electric.xml.IXPath;
import electric.xml.IXPathConstants;
import electric.xml.IXPathFactory;
import electric.xml.Node;
import electric.xml.XPath;
import electric.xml.XPathException;
import electric.xml.xpath.NodeSet;
import java.util.Enumeration;

public class SecurityXPathFactory
implements IXPathConstants,
ISOAPConstants {
    private static IXPathFactory factory;

    public static synchronized IXPath createXPath(String xpathString) throws XPathException {
        if (factory == null) {
            factory = XPath.getFactory(1);
        }
        if (factory == null) {
            throw new XPathException("no xpath factory found");
        }
        return factory.newXPath(xpathString, null);
    }

    public static IXPath createXPath(ElementReference reference) throws XPathException {
        String xpathString = reference.getPath();
        IXPath xpath = SecurityXPathFactory.createXPath(xpathString);
        Enumeration prefixes = reference.getNamespaces();
        while (prefixes.hasMoreElements()) {
            String prefix = (String)prefixes.nextElement();
            String namespace = reference.getNamespace(prefix);
            xpath.setNamespace(prefix, namespace);
        }
        if (reference.getNamespace("soap") == null) {
            xpath.setNamespace("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        }
        return xpath;
    }

    public static NodeSet getSimplePath(Element rootElement, ElementReference reference) throws XPathException {
        String path = reference.getPath();
        if (path.endsWith("/*")) {
            return SecurityXPathFactory.getSimpleStar(path, rootElement, reference);
        }
        return SecurityXPathFactory.getSimpleSingle(rootElement, reference);
    }

    private static NodeSet getSimpleStar(String path, Element rootElement, ElementReference reference) throws XPathException {
        path = path.substring(0, path.length() - 2);
        ElementReference newReference = new ElementReference(reference);
        newReference.setPath(path);
        IXPath xpath = SecurityXPathFactory.createXPath(newReference);
        Element referencedElement = xpath.getElement(rootElement.getDocument());
        if (referencedElement == null) {
            return null;
        }
        Children children = referencedElement.getChildren();
        NodeSet nodeSet = new NodeSet();
        while (children.hasMoreElements()) {
            nodeSet.add(children.nextNode());
        }
        return nodeSet;
    }

    private static NodeSet getSimpleSingle(Element rootElement, ElementReference reference) throws XPathException {
        IXPath xpath = SecurityXPathFactory.createXPath(reference);
        Node node = xpath.getNode(rootElement.getDocument());
        if (node == null) {
            return null;
        }
        NodeSet nodeSet = new NodeSet();
        nodeSet.add(node);
        return nodeSet;
    }
}

