/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.tokens;

import electric.glue.IGLUELoggingConstants;
import electric.soap.SOAPMessage;
import electric.soap.security.IWSSConstants;
import electric.soap.security.WSSContext;
import electric.soap.security.tokens.SecurityToken;
import electric.soap.security.tokens.SecurityTokenFactory;
import electric.soap.security.util.SecurityXPathFactory;
import electric.util.UUID;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.IXMLConstants;
import electric.xml.IXPath;
import electric.xml.Nodes;
import java.util.Vector;

public class SecurityTokenProcessor
implements IWSSConstants,
IXMLConstants,
IGLUELoggingConstants {
    public void addTokens(SOAPMessage message, WSSContext wss, Element securityElement) {
        Vector tokens = wss.out.getSecurityTokens();
        int i = 0;
        while (i < tokens.size()) {
            SecurityToken token = (SecurityToken)tokens.elementAt(i);
            this.addToken(message, wss, securityElement, token);
            ++i;
        }
    }

    public String addToken(SOAPMessage message, WSSContext wss, Element securityElement, SecurityToken token) {
        String id = token.getId();
        if (id == null) {
            id = new UUID().getKey();
            id = "electric-id-" + id;
            token.setId(id);
        }
        Element element = token.getElement();
        securityElement.addChild(element);
        return id;
    }

    public Vector readTokens(SOAPMessage message, WSSContext wss) {
        Vector tokenList;
        block2: {
            tokenList = null;
            try {
                Document doc = message.getDocument();
                IXPath xpathSec = SecurityXPathFactory.createXPath("//wsse:Security[1]");
                xpathSec.setNamespace("wsse", "http://schemas.xmlsoap.org/ws/2002/12/secext");
                SecurityTokenFactory tokenFactory = wss.in.getTokenFactory();
                Element securityElement = xpathSec.getElement(doc.getRoot());
                tokenList = this.processTokens(tokenFactory, securityElement);
            }
            catch (Throwable exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block2;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "problem with security tokens", exception);
            }
        }
        return tokenList;
    }

    protected Vector processTokens(SecurityTokenFactory factory, Element securityElement) throws Exception {
        SecurityToken binaryToken;
        Element tokenElement;
        Vector<SecurityToken> securityTokens = new Vector<SecurityToken>();
        IXPath xpath = SecurityXPathFactory.createXPath("./wsse:BinarySecurityToken");
        xpath.setNamespace("wsse", "http://schemas.xmlsoap.org/ws/2002/12/secext");
        Nodes tokens = xpath.getNodes(securityElement);
        while (tokens.hasMoreElements()) {
            tokenElement = (Element)tokens.nextElement();
            binaryToken = factory.createToken(tokenElement);
            securityTokens.addElement(binaryToken);
        }
        xpath = SecurityXPathFactory.createXPath("./wsse:UsernameToken");
        xpath.setNamespace("wsse", "http://schemas.xmlsoap.org/ws/2002/12/secext");
        tokens = xpath.getNodes(securityElement);
        while (tokens.hasMoreElements()) {
            tokenElement = (Element)tokens.nextElement();
            binaryToken = factory.createToken(tokenElement);
            securityTokens.addElement(binaryToken);
        }
        return securityTokens;
    }
}

