/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.signature.xml.crypto;

import electric.soap.security.signature.xml.XMLSignature;
import electric.soap.security.signature.xml.XMLSignatureException;
import electric.soap.security.signature.xml.crypto.ISignatureAlgorithm;
import electric.soap.security.tokens.SecurityToken;
import electric.soap.security.tokens.X509v3SecurityToken;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;

public class SHA1withRSA
implements ISignatureAlgorithm {
    public boolean verify(XMLSignature signature, SecurityToken securityToken, byte[] bytesToSign, byte[] messageSignature) throws XMLSignatureException {
        X509v3SecurityToken tok = (X509v3SecurityToken)securityToken;
        X509Certificate certificate = tok.getCertificate();
        signature.setCertificate(certificate);
        boolean r = false;
        try {
            Signature signatureVerifier = Signature.getInstance("SHA1withRSA");
            PublicKey publicKey = certificate.getPublicKey();
            signatureVerifier.initVerify(publicKey);
            signatureVerifier.update(bytesToSign);
            r = signatureVerifier.verify(messageSignature);
        }
        catch (Exception exception) {
            throw new XMLSignatureException("SHA1withRSA problem", exception);
        }
        return r;
    }

    public byte[] sign(XMLSignature signature, SecurityToken securityToken, byte[] bytesToSign) throws XMLSignatureException {
        X509v3SecurityToken tok = (X509v3SecurityToken)securityToken;
        X509Certificate cert = tok.getCertificate();
        byte[] signatureBytes = null;
        try {
            Signature signatureGenerator = Signature.getInstance("SHA1withRSA");
            signatureGenerator.initSign(signature.getPrivateKey());
            signatureGenerator.update(bytesToSign);
            signatureBytes = signatureGenerator.sign();
        }
        catch (Exception exception) {
            throw new XMLSignatureException("SHA1withRSA problem", exception);
        }
        return signatureBytes;
    }
}

