/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.signature;

import electric.soap.security.WSSConfigException;
import electric.soap.security.signature.xml.ElementReference;
import electric.soap.security.signature.xml.XMLSignature;
import electric.soap.security.tokens.SecurityToken;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;

public class WSSSignature
extends XMLSignature {
    private static Hashtable signatureSpecs = new Hashtable();

    public WSSSignature() {
    }

    public WSSSignature(String signatureSpecName) throws WSSConfigException {
        WSSSignature signatureSpec = WSSSignature.findSignatureSpec(signatureSpecName);
        if (signatureSpec == null) {
            throw new WSSConfigException("signature template not found: " + signatureSpecName);
        }
        this.init(signatureSpec);
    }

    public WSSSignature(ElementReference reference) {
        this.references.addElement(reference);
    }

    public void init(WSSSignature signature) {
        int i = 0;
        while (i < signature.references.size()) {
            this.references.addElement(signature.references.elementAt(i));
            ++i;
        }
        this.certificate = signature.certificate;
        this.privateKey = signature.privateKey;
    }

    public static void addSignatureSpec(String name, WSSSignature signatureSpec) {
        signatureSpecs.put(name, signatureSpec);
    }

    public static WSSSignature findSignatureSpec(String name) {
        return (WSSSignature)signatureSpecs.get(name);
    }

    public void addReference(ElementReference reference) {
        this.references.addElement(reference);
    }

    public Enumeration getReferences() {
        return this.references.elements();
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public SecurityToken getReferencedToken() {
        return this.referencedToken;
    }

    public void setReferencedToken(SecurityToken referencedToken) {
        this.referencedToken = referencedToken;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }
}

