/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.encryption.xml;

import electric.glue.IGLUELoggingConstants;
import electric.security.IRealm;
import electric.soap.security.encryption.xml.IXMLEncryptionConstants;
import electric.soap.security.encryption.xml.XMLEncryption;
import electric.soap.security.encryption.xml.crypto.EncryptionAlgorithms;
import electric.soap.security.encryption.xml.crypto.IEncryptionAlgorithm;
import electric.soap.security.signature.xml.ElementReference;
import electric.soap.security.util.SecurityXPathFactory;
import electric.util.license.Enabler;
import electric.util.license.LicensingException;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Base64;
import electric.xml.Children;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.IXPath;
import electric.xml.Node;
import electric.xml.Nodes;
import electric.xml.Parent;
import electric.xml.Text;
import electric.xml.canonical.ExclusiveCanonicalizer;
import electric.xml.xpath.NodeSet;

public class XMLEncryptionProcessor
implements IXMLEncryptionConstants,
IGLUELoggingConstants {
    private static boolean enabled = false;
    private static boolean allowEnable = true;

    public static Element addSymmetricEncryption(Element rootElement, String xencPrefix, XMLEncryption encryption) throws Exception {
        if (!XMLEncryptionProcessor.isEnabled()) {
            throw new LicensingException("XML-Encryption");
        }
        ElementReference reference = encryption.getReference();
        if (reference == null) {
            return null;
        }
        NodeSet nodeSet = SecurityXPathFactory.getSimplePath(rootElement, reference);
        if (nodeSet.getLength() == 0) {
            return null;
        }
        NodeSet allNodeSet = XMLEncryptionProcessor.getReferenceNodes(nodeSet);
        ExclusiveCanonicalizer c14n = new ExclusiveCanonicalizer();
        byte[] referencedDataBytes = c14n.canonicalize(allNodeSet, rootElement);
        Element encryptedData = new Element(xencPrefix, "EncryptedData", "http://www.w3.org/2001/04/xmlenc#");
        Node firstReferencedNode = (Node)nodeSet.item(0);
        Node referencedParent = (Node)firstReferencedNode.getParentNode();
        referencedParent.insertBefore(encryptedData, firstReferencedNode);
        NodeSet removedChildren = new NodeSet();
        int i = 0;
        while (i < nodeSet.getLength()) {
            Node referencedNode = (Node)nodeSet.item(i);
            Node referencedNodeParent = (Node)referencedNode.getParentNode();
            if (referencedParent == referencedNodeParent) {
                removedChildren.add((Node)referencedParent.removeChild(referencedNode));
            }
            ++i;
        }
        Element encryptionMethod = new Element(xencPrefix, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#");
        encryptedData.addElement(encryptionMethod);
        String algorithm = encryption.getAlgorithm();
        if (algorithm == null) {
            algorithm = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
        }
        encryptionMethod.setAttribute("Algorithm", algorithm);
        Element keyInfoElement = new Element("ds", "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        encryptedData.setAttributeNS("xmlns", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        encryptedData.addElement(keyInfoElement);
        Element keyName = new Element("ds", "KeyName", "http://www.w3.org/2000/09/xmldsig#");
        keyName.setText(encryption.getKeyName());
        keyInfoElement.addElement(keyName);
        Element cipherDataElement = new Element(xencPrefix, "CipherData", "http://www.w3.org/2001/04/xmlenc#");
        encryptedData.addElement(cipherDataElement);
        Element cipherValueElement = new Element(xencPrefix, "CipherValue", "http://www.w3.org/2001/04/xmlenc#");
        cipherDataElement.addChild(cipherValueElement);
        if (XMLEncryptionProcessor.encrypt(encryption, referencedDataBytes, cipherValueElement)) {
            return encryptedData;
        }
        return null;
    }

    private static NodeSet getReferenceNodes(NodeSet nodeSet) {
        NodeSet allNodeSet = new NodeSet();
        int i = 0;
        while (i < nodeSet.getLength()) {
            Node nodei = (Node)nodeSet.item(i);
            allNodeSet.add(nodei);
            String allFilter = "(.//. | .//@* | .//namespace::*)";
            IXPath xpathAll = SecurityXPathFactory.createXPath(allFilter);
            Nodes allNodesList = xpathAll.getNodes(nodei);
            NodeSet allNodes = new NodeSet(allNodesList);
            allNodeSet.add(allNodes);
            ++i;
        }
        return allNodeSet;
    }

    private static boolean encrypt(XMLEncryption encryption, byte[] referencedDataBytes, Element cipherValueElement) {
        try {
            String algorithm = encryption.getAlgorithm();
            if (algorithm == null) {
                algorithm = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            }
            IEncryptionAlgorithm encrypter = EncryptionAlgorithms.getEncryptionAlgorithm(algorithm);
            byte[] secretKeyBytes = encryption.getSecretKeyBytes();
            byte[] cipheredDataBytes = encrypter.encrypt(referencedDataBytes, secretKeyBytes);
            String cipheredString = Base64.toBase64(cipheredDataBytes);
            cipherValueElement.setText(cipheredString);
            return true;
        }
        catch (Exception exception) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)("problem with encryption" + exception));
            }
            return false;
        }
    }

    public static boolean decryptAndReplace(Document document, XMLEncryption encryptionResult, IRealm realm, String dataReferenceURI) {
        if (!XMLEncryptionProcessor.isEnabled()) {
            throw new LicensingException("XML-Encryption");
        }
        Element encryptedDataElement = XMLEncryptionProcessor.getEncryptedDataElement(document, dataReferenceURI);
        if (encryptedDataElement == null) {
            return false;
        }
        IEncryptionAlgorithm encryptionAlgorithm = XMLEncryptionProcessor.getEncryptionAlgorithm(encryptedDataElement);
        if (encryptionAlgorithm == null) {
            return false;
        }
        String secretKeyName = XMLEncryptionProcessor.getSecretKeyName(encryptedDataElement);
        if (secretKeyName == null) {
            return false;
        }
        encryptionResult.setKeyName(secretKeyName);
        String secretKeyString = XMLEncryptionProcessor.getSecretKeyString(secretKeyName, realm);
        if (secretKeyString == null) {
            return false;
        }
        encryptionResult.setRealm(realm);
        byte[] cipherData = XMLEncryptionProcessor.getCipherData(encryptedDataElement);
        if (cipherData == null) {
            return false;
        }
        String encoding = document.getEncoding();
        encoding = "UTF8";
        String decipheredData = XMLEncryptionProcessor.decipher(secretKeyString, encryptionAlgorithm, cipherData, encoding);
        if (decipheredData == null) {
            return false;
        }
        NodeSet replacementNodes = XMLEncryptionProcessor.stringToNodes(decipheredData);
        encryptionResult.setDecryptedNodes(replacementNodes);
        return XMLEncryptionProcessor.replaceEncryptedData(encryptedDataElement, replacementNodes);
    }

    private static Element getEncryptedDataElement(Document document, String dataReferenceURI) {
        Element referencedElement = XMLEncryptionProcessor.dereferenceURI(document, dataReferenceURI);
        if (referencedElement == null) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)("xml encryption processor, referenced element not found: " + dataReferenceURI));
            }
            return null;
        }
        if (!referencedElement.getLocalName().equals("EncryptedData")) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)("xml encryption processor, referenced element not encrypted data: " + dataReferenceURI));
            }
            return null;
        }
        String referencedElementNamespace = referencedElement.getNamespace();
        if (!"http://www.w3.org/2001/04/xmlenc#".equals(referencedElementNamespace)) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)("xml encryption processor, referenced element not encrypted data wrong namespace:" + referencedElementNamespace));
            }
            return null;
        }
        return referencedElement;
    }

    public static Element dereferenceURI(Parent envelope, String URI2) {
        String referencePath = null;
        String referencedId = null;
        if (URI2.startsWith("#")) {
            referencedId = URI2.substring(1);
            referencePath = "//*[@wsu:Id=\"" + referencedId + '\"' + "]";
        } else {
            referencePath = URI2;
        }
        IXPath referencedDataPath = SecurityXPathFactory.createXPath(referencePath);
        referencedDataPath.setNamespace("wsu", "http://schemas.xmlsoap.org/ws/2002/07/utility");
        Element referencedElement = referencedDataPath.getElement(envelope);
        if (referencedElement == null) {
            referencedElement = envelope.getElementWithId(referencedId);
        }
        return referencedElement;
    }

    private static IEncryptionAlgorithm getEncryptionAlgorithm(Element encryptedDataElement) {
        Element encryptionMethodElement = encryptedDataElement.getElement("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
        if (encryptionMethodElement == null) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)"xml encryption processor, encryption method not found");
            }
            return null;
        }
        String encryptionAlgorithm = encryptionMethodElement.getAttribute("Algorithm");
        if (encryptionAlgorithm == null) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)"xml encryption processor, encryption algorithm attribute not found");
            }
            return null;
        }
        IEncryptionAlgorithm decryptor = EncryptionAlgorithms.getEncryptionAlgorithm(encryptionAlgorithm);
        if (decryptor == null && Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
            Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)("xml encryption processor, decryptor not found: " + encryptionAlgorithm));
        }
        return decryptor;
    }

    private static String getSecretKeyName(Element encryptedDataElement) {
        IXPath keyNamePath = SecurityXPathFactory.createXPath("./ds:KeyInfo/ds:KeyName");
        keyNamePath.setNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        Element keyNameElement = keyNamePath.getElement(encryptedDataElement);
        if (keyNameElement == null) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)"xml encryption processor, bad keyinfo, no key name found");
            }
            return null;
        }
        String keyName = keyNameElement.getString();
        if (keyName.length() == 0) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)"xml encryption processor, bad keyinfo, key name empty");
            }
            return null;
        }
        return keyName;
    }

    private static String getSecretKeyString(String keyName, IRealm realm) {
        String secretKeyString = realm.getPassword(keyName);
        if (secretKeyString == null) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)("xml encryption processor, secret key not found:" + keyName + "/" + realm.getName()));
            }
            return null;
        }
        return secretKeyString;
    }

    private static byte[] getCipherData(Element encryptedDataElement) {
        Element cipherDataElement = encryptedDataElement.getElement("http://www.w3.org/2001/04/xmlenc#", "CipherData");
        if (cipherDataElement == null) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)"xml encryption processor, cipher data element not found");
            }
            return null;
        }
        Element cipherValueElement = cipherDataElement.getElement("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        if (cipherValueElement == null) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)"xml encryption processor, cipher value element not found");
            }
            return null;
        }
        String cipherValueString = cipherValueElement.getString();
        if (cipherValueString.length() == 0) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)"xml encryption processor, cipher value string empty");
            }
            return null;
        }
        return Base64.fromBase64(cipherValueString);
    }

    private static String decipher(String secretKeyString, IEncryptionAlgorithm decryptor, byte[] cipherData, String encoding) {
        try {
            byte[] secretKeyBytes = Base64.fromBase64(secretKeyString);
            byte[] decipheredDataBytes = decryptor.decrypt(cipherData, secretKeyBytes);
            if (decipheredDataBytes == null) {
                if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                    Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)"xml encryption processor, decipher failed");
                }
                return null;
            }
            String decipheredData = new String(decipheredDataBytes, encoding);
            return decipheredData;
        }
        catch (Exception ex) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)"xml encryption processor, decipher failed");
            }
            return null;
        }
    }

    private static NodeSet stringToNodes(String decipheredData) {
        NodeSet replacementNodes = new NodeSet();
        try {
            String wrappedData = "<root>" + decipheredData + "</root>";
            Document replacementDoc = new Document(wrappedData);
            Children children = replacementDoc.getRoot().getChildren();
            while (children.hasMoreElements()) {
                Node child = children.nextNode();
                replacementNodes.add(child);
            }
        }
        catch (Throwable exception) {
            Text replacementText = new Text(decipheredData);
            replacementNodes.add(replacementText);
        }
        return replacementNodes;
    }

    private static boolean replaceEncryptedData(Element encryptedDataElement, NodeSet replacementNodes) {
        try {
            Element parent = (Element)encryptedDataElement.getParent();
            int i = 0;
            while (i < replacementNodes.getLength()) {
                parent.insertBefore(replacementNodes.item(i), encryptedDataElement);
                ++i;
            }
            parent.removeChild(encryptedDataElement);
            return true;
        }
        catch (Exception exception) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)"ReferenceListHandler.handle():problem with cipher");
            }
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "ReferenceListHandler.handle():problem with cipher", exception);
            }
            return false;
        }
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("XML-Encryption cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
    }

    public static final boolean isEnabled() {
        return enabled;
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"XML-Encryption disabled");
    }
}

