/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.encryption;

import electric.security.IRealm;
import electric.soap.ISOAPConstants;
import electric.soap.SOAPMessage;
import electric.soap.security.IWSSConstants;
import electric.soap.security.WSSContext;
import electric.soap.security.encryption.WSSEncryption;
import electric.soap.security.encryption.WSSReferenceListHandler;
import electric.soap.security.encryption.xml.IXMLEncryptionConstants;
import electric.soap.security.encryption.xml.XMLEncryptionProcessor;
import electric.soap.security.guards.EncryptionGuard;
import electric.soap.security.tokens.SecurityTokenProcessor;
import electric.soap.security.tokens.X509v3SecurityToken;
import electric.soap.security.util.SecurityXPathFactory;
import electric.util.UUID;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IXMLConstants;
import electric.xml.IXPath;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WSSEncryptionProcessor
implements IWSSConstants,
IXMLConstants,
ISOAPConstants,
IXMLEncryptionConstants {
    private static IRealm defaultRealm;
    private SecurityTokenProcessor tokenProcessor;

    public WSSEncryptionProcessor(SecurityTokenProcessor tokenProcessor) {
        this.tokenProcessor = tokenProcessor;
    }

    public void addEncryptionCertificates(SOAPMessage message, WSSContext wss, Element securityElement, Hashtable certToId) {
        Vector encryptions = wss.out.getEncryptions();
        int i = 0;
        while (i < encryptions.size()) {
            WSSEncryption encryption = (WSSEncryption)encryptions.elementAt(i);
            X509Certificate cert = encryption.getCertificate();
            if (cert != null && !certToId.containsKey(cert)) {
                X509v3SecurityToken certToken = new X509v3SecurityToken(cert);
                String id = this.tokenProcessor.addToken(message, wss, securityElement, certToken);
                certToken.setId(id);
                certToId.put(cert, id);
            }
            ++i;
        }
    }

    public static Element createReferenceList(String xencPrefix) {
        Element referenceListElement = null;
        if (xencPrefix == null) {
            xencPrefix = "xenc";
            referenceListElement = new Element(xencPrefix, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#");
            referenceListElement.setAttributeNS("xmlns", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        } else {
            referenceListElement = new Element(xencPrefix, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#");
        }
        return referenceListElement;
    }

    public void addEncryptions(SOAPMessage message, WSSContext wss, Element securityElement, Hashtable certToId) throws Exception {
        Vector encryptions = wss.out.getEncryptions();
        if (encryptions.size() > 0) {
            int i = 0;
            while (i < encryptions.size()) {
                WSSEncryption encryption = (WSSEncryption)encryptions.elementAt(i);
                this.addEncryption(message, securityElement, wss, encryption, certToId);
                ++i;
            }
        }
    }

    public void addEncryption(SOAPMessage message, Element securityElement, WSSContext context, WSSEncryption encryption, Hashtable certToId) throws Exception {
        byte[] secretKeyBytes = encryption.getSecretKeyBytes();
        if (secretKeyBytes != null) {
            this.addSymmetricEncryption(message, securityElement, context, encryption, certToId);
            return;
        }
    }

    public void addSymmetricEncryption(SOAPMessage message, Element securityElement, WSSContext context, WSSEncryption encryption, Hashtable certToId) throws Exception {
        Element envelope;
        Element encryptedData;
        Element referenceListElement = securityElement.getElement("http://www.w3.org/2001/04/xmlenc#", "ReferenceList");
        String xencPrefix = securityElement.getPrefix("http://www.w3.org/2001/04/xmlenc#");
        if (referenceListElement == null) {
            referenceListElement = WSSEncryptionProcessor.createReferenceList(xencPrefix);
        }
        if ((encryptedData = XMLEncryptionProcessor.addSymmetricEncryption(envelope = message.getRoot(), xencPrefix, encryption)) == null) {
            return;
        }
        Element dataReference = new Element(xencPrefix, "DataReference", "http://www.w3.org/2001/04/xmlenc#");
        referenceListElement.addElement(dataReference);
        String Id2 = new UUID().getKey();
        Id2 = "electric-id-" + Id2;
        String wsuPrefix = referenceListElement.getPrefix("http://schemas.xmlsoap.org/ws/2002/07/utility");
        if (wsuPrefix == null) {
            wsuPrefix = "wsu";
            dataReference.setAttributeNS("xmlns", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        }
        dataReference.setAttribute("URI", "#" + Id2);
        referenceListElement.addElement(dataReference);
        encryptedData.setAttribute("Id", Id2);
        securityElement.addElement(referenceListElement);
    }

    public Vector getEncrytionGuards(Enumeration guards) {
        Vector<EncryptionGuard> encryptionGuards = new Vector<EncryptionGuard>();
        while (guards.hasMoreElements()) {
            Object guard = guards.nextElement();
            if (!(guard instanceof EncryptionGuard)) continue;
            EncryptionGuard encryptionGuard = (EncryptionGuard)guard;
            encryptionGuards.addElement(encryptionGuard);
        }
        return encryptionGuards;
    }

    public void decrypt(SOAPMessage message, Vector encryptions, Enumeration guards) {
        Vector encryptionGuards = this.getEncrytionGuards(guards);
        if (encryptionGuards.size() == 0) {
            return;
        }
        EncryptionGuard firstGuard = (EncryptionGuard)encryptionGuards.elementAt(0);
        IRealm realm = firstGuard.getEncryptionSpec().getRealm();
        if (realm == null) {
            realm = defaultRealm;
        }
        Element envelope = message.getEnvelope();
        IXPath securityPath = SecurityXPathFactory.createXPath("//wsse:Security");
        securityPath.setNamespace("wsse", "http://schemas.xmlsoap.org/ws/2002/12/secext");
        Elements securityElements = securityPath.getElements(envelope);
        while (securityElements.hasMoreElements()) {
            Element securityElement = securityElements.next();
            WSSEncryptionProcessor.decrypt(envelope, securityElement, realm, encryptions);
        }
    }

    private static void decrypt(Element envelope, Element securityElement, IRealm realm, Vector encryptions) {
        WSSReferenceListHandler referenceListHandler = new WSSReferenceListHandler();
        WSSEncryption encryptionResult = referenceListHandler.handle(envelope, securityElement, realm);
        if (encryptionResult != null) {
            encryptions.addElement(encryptionResult);
        }
    }
}

