/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.encryption;

import electric.soap.security.IWSSConstants;
import electric.soap.security.SOAPSecurityException;
import electric.soap.security.encryption.xml.XMLEncryption;
import java.util.Hashtable;

public class WSSEncryption
extends XMLEncryption
implements IWSSConstants {
    private static Hashtable encryptionSpecs = new Hashtable();

    public WSSEncryption() {
    }

    public WSSEncryption(String encryptionSpecName) throws SOAPSecurityException {
        WSSEncryption encryptionSpec = WSSEncryption.findEncryptionSpec(encryptionSpecName);
        if (encryptionSpec == null) {
            throw new SOAPSecurityException("WSSEncryption.WSSEncryption():'" + encryptionSpecName + "' not found");
        }
        this.init(encryptionSpec);
    }

    private void init(WSSEncryption encryptionSpec) {
        this.reference = encryptionSpec.reference;
        this.realm = encryptionSpec.realm;
        this.userName = encryptionSpec.userName;
        this.secretKeyBytes = encryptionSpec.secretKeyBytes;
        this.algorithm = encryptionSpec.algorithm;
    }

    public static void addEncryptionSpec(String name, WSSEncryption encryptionSpec) {
        encryptionSpecs.put(name, encryptionSpec);
    }

    public static WSSEncryption findEncryptionSpec(String name) {
        return (WSSEncryption)encryptionSpecs.get(name);
    }
}

