/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security;

import electric.soap.SOAPMessage;
import electric.soap.security.authenticators.IWSSAuthenticator;
import electric.soap.security.guards.IWSSGuard;
import electric.soap.security.tokens.SecurityTokenFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WSSContextIn {
    protected SecurityTokenFactory tokenFactory;
    protected Vector authenticators = new Vector();
    protected Hashtable authenticatorNames = new Hashtable();
    protected Vector authorizers = new Vector();

    public WSSContextIn() {
        this.tokenFactory = new SecurityTokenFactory();
    }

    public SecurityTokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    public void addAuthenticator(IWSSAuthenticator authenticate) {
        this.authenticators.addElement(authenticate);
    }

    public void addAuthenticator(IWSSAuthenticator authenticate, String name) {
        this.addAuthenticator(authenticate);
        if (name != null) {
            this.authenticatorNames.put(name, authenticate);
        }
    }

    public IWSSAuthenticator getAuthenticatorByName(String name) {
        return (IWSSAuthenticator)this.authenticatorNames.get(name);
    }

    public Enumeration authenticators() {
        return this.authenticators.elements();
    }

    public boolean authenticate(SOAPMessage message, Vector tokenList, Vector principalList) {
        boolean authorized = true;
        int i = 0;
        while (i < this.authenticators.size()) {
            IWSSAuthenticator authenticator = (IWSSAuthenticator)this.authenticators.elementAt(i);
            authorized = authenticator.authenticate(message, tokenList, principalList);
            if (!authorized) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addGuard(IWSSGuard authorizer) {
        this.authorizers.addElement(authorizer);
    }

    public boolean authorize(SOAPMessage message, Vector signatures, Vector encryptions, Vector principalList) {
        int i = 0;
        while (i < this.authorizers.size()) {
            Vector authorizedCredentials;
            IWSSGuard authorizer = (IWSSGuard)this.authorizers.elementAt(i);
            if (!authorizer.authorize(message, signatures, encryptions, principalList, authorizedCredentials = new Vector())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Enumeration guards() {
        return this.authorizers.elements();
    }
}

