/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.references.logging;

import electric.glue.IGLUELoggingConstants;
import electric.soap.SOAPMessage;
import electric.soap.references.chain.ChainedSOAPReference;
import electric.util.Context;
import electric.util.XURL;
import electric.util.log.Log;
import electric.wsdl.WSDL;
import java.rmi.RemoteException;

public class LoggingSOAPReference
extends ChainedSOAPReference
implements IGLUELoggingConstants {
    private XURL endpoint;

    public LoggingSOAPReference(XURL endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        return "LoggingSOAPReference( nextReference=" + this.getNextReference() + " )";
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        if (Log.isLogging(IGLUELoggingConstants.SOAP_EVENT)) {
            Log.log(IGLUELoggingConstants.SOAP_EVENT, (Object)("request to " + this.endpoint + "\n" + request + "\n"));
        }
        SOAPMessage response = this.nextReference.handle(request, messageContext);
        if (Log.isLogging(IGLUELoggingConstants.SOAP_EVENT)) {
            Log.log(IGLUELoggingConstants.SOAP_EVENT, (Object)("response from " + this.endpoint + "\n" + response + "\n"));
        }
        return response;
    }

    public WSDL getWSDL() {
        return this.nextReference.getWSDL();
    }

    public XURL getEndpoint() {
        return this.nextReference.getEndpoint();
    }
}

