/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.local.handlers.user;

import electric.service.IService;
import electric.soap.ISOAPConstants;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPMessage;
import electric.soap.util.SOAPEncodings;
import electric.util.Context;
import electric.util.XURL;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;

public final class SOAPToUserHandler
implements ISOAPHandler,
ISOAPConstants {
    private IService service;

    public SOAPToUserHandler(IService service) {
        this.service = service;
    }

    public String toString() {
        return this.service.toString();
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) {
        SOAPMessage response;
        XURL endpoint = (XURL)messageContext.getProperty("endpoint");
        try {
            if (this.service == null) {
                throw new NotBoundException("no service found with address " + endpoint);
            }
            response = this.invoke(request, messageContext);
        }
        catch (Throwable exception) {
            response = new SOAPMessage();
            response.setException(exception);
        }
        if (response == null) {
            return null;
        }
        SOAPEncodings.setEncoding(response);
        return response;
    }

    private SOAPMessage invoke(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        ISOAPHandler handler = (ISOAPHandler)((Object)this.service);
        request.deoptimize();
        return handler.handle(request, messageContext);
    }
}

