/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.local.handlers.service;

import electric.proxy.IReference;
import electric.service.IService;
import electric.soap.ISOAPConstants;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.soap.local.handlers.service.IOperationLookup;
import electric.soap.local.handlers.service.OperationLookupFactories;
import electric.soap.util.SOAPEncodings;
import electric.soap.util.SOAPHeaders;
import electric.soap.wsdl.SOAPOperation;
import electric.util.Context;
import electric.util.Value;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.async.Async;
import electric.wsdl.Operation;
import java.rmi.NotBoundException;

public final class SOAPToServiceHandler
implements ISOAPHandler,
ISOAPConstants {
    private IService service;
    private IOperationLookup operationLookup;

    public SOAPToServiceHandler(IService service) {
        this.service = service;
        this.operationLookup = OperationLookupFactories.getOperationLookup(service);
    }

    public String toString() {
        return this.service.toString();
    }

    public SOAPMessage handle(SOAPMessage request, Context context) {
        SOAPMessage response;
        XURL endpoint = (XURL)context.getProperty("endpoint");
        try {
            if (this.service == null) {
                throw new NotBoundException("no service found with address " + endpoint);
            }
            response = this.invoke(request, context);
        }
        catch (Throwable exception) {
            response = new SOAPMessage();
            response.setException(exception);
        }
        if (response == null) {
            return null;
        }
        SOAPEncodings.setEncoding(response);
        return response;
    }

    private SOAPMessage invoke(SOAPMessage request, Context context) throws Throwable {
        SOAPOptimizations.checkOptimizations(request.getOptimizations(), this.service.getWSDL());
        SOAPHeaders.checkHeaders(request, context);
        SOAPOperation operation = this.operationLookup.getOperation(request);
        Object[] args = operation.getArgs(request);
        IReference reference = this.service.getReference();
        if (operation.isAsync()) {
            Async async = (Async)context.getProperty("async");
            args = (Object[])ArrayUtil.addElement(args, async);
        }
        Value result = null;
        try {
            result = reference.invoke(operation.getMethod(), args, this.service.getContext());
        }
        catch (Exception exception) {
            SOAPMessage response;
            if (Operation.processFaults() && (response = operation.generateFault(exception, request)) != null) {
                return response;
            }
            throw exception;
        }
        if (operation.isAsync()) {
            return null;
        }
        SOAPMessage response = new SOAPMessage();
        operation.writeResponse(response, request.getOptimizations(), args, result);
        return response;
    }
}

