/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.jms.handler;

import electric.glue.IGLUELoggingConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.IServer;
import electric.server.Servers;
import electric.server.jms.AsyncTransport;
import electric.server.jms.IJMSConstants;
import electric.server.jms.JMSRequest;
import electric.service.IService;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPException;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.soap.handlers.SOAPHandlerFactories;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ByteArray;
import electric.util.async.Async;
import electric.util.jms.JMSUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.io.schema.SchemaProperties;
import java.net.MalformedURLException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

public class JMSToSOAP
implements IJMSConstants,
IGLUELoggingConstants {
    public void handle(JMSRequest jmsRequest) {
        block21: {
            String messageId = null;
            String serviceURN = null;
            IService service = null;
            SOAPMessage request = null;
            Queue responseQueue = jmsRequest.getResponseQueue();
            QueueSession responseSession = jmsRequest.createResponseSession();
            BytesMessage mainMessage = jmsRequest.getMainMessage();
            try {
                SOAPOptimizations optimizations;
                messageId = mainMessage.getJMSMessageID();
                if (!mainMessage.propertyExists("serviceURN")) {
                    throw new IllegalArgumentException("invalid invocation request. missing the serviceURN property");
                }
                serviceURN = mainMessage.getStringProperty("serviceURN");
                if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
                    Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)("invocation request for " + serviceURN));
                }
                service = this.getService(serviceURN);
                String description = mainMessage.getStringProperty("GLUEOptimized");
                SOAPOptimizations sOAPOptimizations = optimizations = description != null ? new SOAPOptimizations(description) : SOAPOptimizations.DEFAULT;
                if (jmsRequest.getTotalParts() == 0) {
                    request = new SOAPMessage();
                    byte[] bytes = JMSUtil.getMessageBytes(mainMessage);
                    request.setBytes(bytes, optimizations, null);
                }
                if (service == null) {
                    throw new SOAPException("no service found with address " + serviceURN);
                }
            }
            catch (Throwable throwable) {
                block20: {
                    block19: {
                        if (responseQueue == null) {
                            return;
                        }
                        SOAPMessage response = new SOAPMessage();
                        if (throwable instanceof SOAPException) {
                            response.setException(throwable);
                        } else {
                            response.setException(new SOAPException("dispatch error: " + throwable, "Server"));
                        }
                        try {
                            BytesMessage message = responseSession.createBytesMessage();
                            ByteArray byteArray = response.getByteArray();
                            message.writeBytes(byteArray.bytes, byteArray.offset, byteArray.length);
                            message.setJMSCorrelationID(messageId);
                            QueueSender queueSender = responseSession.createSender(responseQueue);
                            queueSender.send((Message)message);
                            queueSender.close();
                        }
                        catch (Exception exception) {
                            if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
                                Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)("exception while attempting delivery of the response. response - " + response));
                            }
                            if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block19;
                            Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                        }
                    }
                    try {
                        responseSession.close();
                    }
                    catch (JMSException exception) {
                        if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
                            Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)("exception while closing JMS session. " + exception.toString()));
                        }
                        if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block20;
                        Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                    }
                }
                return;
            }
            SOAPMessage response = null;
            try {
                Context messageContext = new Context();
                XURL endpoint = new XURL(serviceURN);
                messageContext.setProperty("endpoint", endpoint);
                ISOAPHandler handlerChain = SOAPHandlerFactories.getSOAPHandlerChain(service);
                if (request.getHeaderElement(SchemaProperties.getTmeNamespace(), "async") == null) {
                    response = handlerChain.handle(request, messageContext);
                    QueueSender sender = responseSession.createSender(responseQueue);
                    BytesMessage responseMessage = responseSession.createBytesMessage();
                    responseMessage.setJMSCorrelationID(messageId);
                    ByteArray byteArray = response.getByteArray();
                    responseMessage.writeBytes(byteArray.bytes, byteArray.offset, byteArray.length);
                    sender.send((Message)responseMessage);
                    sender.close();
                    break block21;
                }
                AsyncTransport transport = new AsyncTransport();
                this.setResponseQueueName(transport, mainMessage, responseQueue);
                transport.setConnFactoryName(jmsRequest.getJMSContext().queueConnFactName);
                transport.setMessageId(messageId);
                transport.setQueue(responseQueue);
                transport.setQueueSession(responseSession);
                messageContext.setProperty("async", new Async(transport));
                response = handlerChain.handle(request, messageContext);
            }
            catch (Exception exception) {
                if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
                    Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)("exception while attempting delivery of the response. response - " + response));
                }
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block21;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
        }
    }

    private void setResponseQueueName(AsyncTransport transport, BytesMessage mainMessage, Queue responseQueue) {
        block4: {
            try {
                transport.setQueueName(mainMessage.getStringProperty("jmsResponseQueue"));
            }
            catch (JMSException exception) {
                try {
                    transport.setQueueName(responseQueue.getQueueName());
                }
                catch (JMSException exception1) {
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block4;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                }
            }
        }
    }

    private IService getService(String serviceURN) throws RegistryException, MalformedURLException {
        IServer server = Servers.getServerForPath(new XURL(serviceURN));
        Object target = Registry.get(serviceURN = server.getLocalPath(serviceURN));
        if (!(target instanceof IService)) {
            return null;
        }
        return (IService)target;
    }
}

