/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.java.reference;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.proxy.IReference;
import electric.soap.ISOAPConstants;
import electric.soap.SOAPException;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.soap.references.ISOAPReference;
import electric.soap.references.chain.ChainedSOAPReference;
import electric.soap.util.SOAPEncodings;
import electric.soap.wsdl.SOAPBinding;
import electric.soap.wsdl.SOAPOperation;
import electric.soap.wsdl.WSDLTagData;
import electric.util.Context;
import electric.util.Value;
import electric.util.XURL;
import electric.util.async.Async;
import electric.wsdl.Binding;
import electric.wsdl.Operation;
import electric.wsdl.Operations;
import electric.wsdl.Service;
import electric.wsdl.WSDL;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Enumeration;

public final class JavaToSOAP
extends ChainedSOAPReference
implements IReference,
ISOAPConstants,
IGLUELoggingConstants,
IGLUEContextConstants {
    private Operations operations;
    private XURL endpoint;
    private SOAPOptimizations optimizations = SOAPOptimizations.DEFAULT;
    static /* synthetic */ Class class$electric$soap$wsdl$SOAPPort;
    static /* synthetic */ Class class$electric$soap$wsdl$SOAPBinding;

    public JavaToSOAP(XURL endpoint, ISOAPReference nextReference, Context proxyContext) {
        this.endpoint = endpoint;
        this.nextReference = nextReference;
        WSDL wsdl = nextReference.getWSDL();
        if (wsdl != null) {
            Enumeration services = wsdl.getServices();
            if (services.hasMoreElements()) {
                this.operations = ((Service)services.nextElement()).getOperations(class$electric$soap$wsdl$SOAPPort == null ? (class$electric$soap$wsdl$SOAPPort = JavaToSOAP.class$("electric.soap.wsdl.SOAPPort")) : class$electric$soap$wsdl$SOAPPort);
                if (proxyContext.getProperty("endpoint") == null) {
                    this.setOptimizations(wsdl);
                }
            } else {
                this.operations = wsdl.getOperationsForBindingClass(class$electric$soap$wsdl$SOAPBinding == null ? (class$electric$soap$wsdl$SOAPBinding = JavaToSOAP.class$("electric.soap.wsdl.SOAPBinding")) : class$electric$soap$wsdl$SOAPBinding);
            }
        }
    }

    public String toString() {
        return this.endpoint.toString();
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        return this.nextReference.handle(request, messageContext);
    }

    public WSDL getWSDL() {
        return this.nextReference.getWSDL();
    }

    public XURL getEndpoint() {
        return this.endpoint;
    }

    public Operations getOperations() {
        return this.operations;
    }

    public Value invoke(Method method, Object[] args, Context proxyContext) throws Throwable {
        try {
            SOAPOperation operation = (SOAPOperation)this.operations.getOperation(method);
            return this.invoke(operation, args);
        }
        catch (SOAPException exception) {
            throw exception.forRethrow(method.getExceptionTypes());
        }
    }

    public Value invoke(String method, Object[] args, Class[] argTypes, Context proxyContext) throws Throwable {
        SOAPOperation operation = (SOAPOperation)this.operations.getOperation(method, argTypes);
        return this.invoke(operation, args);
    }

    public Value invoke(String method, String[] args, Context proxyContext) throws Throwable {
        SOAPOperation operation = (SOAPOperation)this.operations.getOperation(method, args.length);
        Object[] objects = new Object[args.length];
        int i = 0;
        while (i < args.length) {
            objects[i] = operation.parameters[i].valueOf(args[i]);
            ++i;
        }
        return this.invoke(operation, objects);
    }

    public Value invoke(SOAPOperation operation, Object[] args) throws RemoteException, SecurityException {
        SOAPMessage response;
        SOAPMessage request = new SOAPMessage();
        operation.writeRequest(request, this.getOptimizations(operation), args);
        if (operation.getSOAPAction() != null && operation.isSoapActionRequired()) {
            request.addMIMEHeader("SOAPAction", operation.getSOAPAction());
        }
        SOAPEncodings.setEncoding(request);
        Context messageContext = new Context();
        if (operation.isAsync() && args.length > 0 && args[args.length - 1] instanceof Async) {
            messageContext.setProperty("async", args[args.length - 1]);
        }
        if ((response = this.handle(request, messageContext)) == null) {
            return Value.NULL;
        }
        if (response.isException()) {
            RemoteException exception;
            if (Operation.processFaults() && !Operation.useOldStyleFaults() && (exception = operation.mapFaultToException(response)) != null) {
                throw exception;
            }
            throw response.getSOAPException();
        }
        return operation.readResponse(response, args);
    }

    private void setOptimizations(WSDL wsdl) {
        Binding[] soapBindings = wsdl.getBindings(class$electric$soap$wsdl$SOAPBinding == null ? (class$electric$soap$wsdl$SOAPBinding = JavaToSOAP.class$("electric.soap.wsdl.SOAPBinding")) : class$electric$soap$wsdl$SOAPBinding);
        if (soapBindings.length == 0) {
            return;
        }
        SOAPBinding soapBinding = (SOAPBinding)soapBindings[0];
        SOAPOptimizations portOptimizations = soapBinding.getOptimizations();
        if (portOptimizations != null) {
            this.optimizations = portOptimizations.getTagSubstitution() ? new SOAPOptimizations(portOptimizations, WSDLTagData.getTagData(wsdl).getHashCode()) : new SOAPOptimizations(portOptimizations, 0L);
        }
        if (SOAPOptimizations.isTypeOmissionEnabled()) {
            this.optimizations.setTypeOmission(true);
        }
        this.optimizations.stripDisabled();
    }

    private synchronized SOAPOptimizations getOptimizations(SOAPOperation operation) {
        return operation.selectOptimizations(this.optimizations);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

