/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.handlers.setup;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.service.IService;
import electric.soap.ISOAPConstants;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPMessage;
import electric.soap.handlers.chain.ChainedSOAPHandler;
import electric.util.Context;
import electric.util.classloader.ClassLoaders;
import electric.util.classloader.IHasClassLoader;
import java.rmi.RemoteException;

public final class SetupHandler
extends ChainedSOAPHandler
implements ISOAPConstants,
IGLUELoggingConstants,
IGLUEContextConstants {
    private IService service;

    public SetupHandler(IService service, ISOAPHandler nextHandler) {
        super(nextHandler);
        this.service = service;
    }

    public String toString() {
        return this.service.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        Context threadContext = Context.thread();
        threadContext.setProperty("soapRequest", request);
        threadContext.setProperty("service", this.service);
        ClassLoader classLoader = ClassLoaders.getContextClassLoader();
        if (this.service instanceof IHasClassLoader) {
            ClassLoaders.setContextClassLoader(((IHasClassLoader)((Object)this.service)).getClassLoader());
        }
        try {
            SOAPMessage sOAPMessage = this.nextHandler.handle(request, messageContext);
            return sOAPMessage;
        }
        finally {
            threadContext.removeProperty("service");
            threadContext.removeProperty("soapRequest");
            if (this.service instanceof IHasClassLoader) {
                ClassLoaders.setContextClassLoader(classLoader);
            }
        }
    }
}

