/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.handlers;

import electric.service.IService;
import electric.soap.ISOAPHandler;
import electric.soap.handlers.Entry;
import electric.soap.handlers.ISOAPHandlerFactory;
import electric.util.Context;
import electric.util.array.ArrayUtil;

public class SOAPHandlerFactories {
    private static final int DEFAULT_PRIORITY = 5;
    private static Entry[] entries = new Entry[0];

    public static void addFactory(String name, ISOAPHandlerFactory factory) {
        SOAPHandlerFactories.addFactory(name, factory, 5.0f);
    }

    public static void addFactory(String name, ISOAPHandlerFactory factory, float priority) {
        Entry entry = new Entry(name, priority, factory);
        int i = 0;
        while (i < entries.length) {
            if (priority < SOAPHandlerFactories.entries[i].priority) {
                entries = (Entry[])ArrayUtil.insertElementAt(entries, entry, i);
                return;
            }
            ++i;
        }
        entries = (Entry[])ArrayUtil.addElement(entries, entry);
    }

    public static ISOAPHandlerFactory getFactory(String name) {
        int i = 0;
        while (i < entries.length) {
            if (SOAPHandlerFactories.entries[i].name.equals(name)) {
                return SOAPHandlerFactories.entries[i].factory;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISOAPHandler getSOAPHandlerChain(IService service) {
        Context serviceContext;
        Context context = serviceContext = service.getContext();
        synchronized (context) {
            ISOAPHandler handlerChain = (ISOAPHandler)serviceContext.getProperty("soapHandlerChain");
            if (handlerChain == null) {
                handlerChain = SOAPHandlerFactories.newSOAPHandlerChain(service);
                serviceContext.setProperty("soapHandlerChain", handlerChain);
            }
            return handlerChain;
        }
    }

    public static ISOAPHandler newSOAPHandlerChain(IService service) {
        if (entries.length == 0) {
            return null;
        }
        ISOAPHandler reference = null;
        ISOAPHandler lastReference = null;
        int i = entries.length - 1;
        while (i >= 0) {
            reference = SOAPHandlerFactories.entries[i].factory.newSOAPHandler(service, lastReference);
            if (reference != null) {
                lastReference = reference;
            }
            --i;
        }
        return reference;
    }
}

