/*
 * Decompiled with CFR 0.152.
 */
package electric.soap;

import electric.glue.IGLUELoggingConstants;
import electric.soap.ISOAPConstants;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import electric.xml.io.encoded.EncodedReader;
import electric.xml.io.encoded.EncodedWriter;
import electric.xml.io.schema.SchemaProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.rmi.RemoteException;

public class SOAPException
extends RemoteException
implements ISOAPConstants,
IGLUELoggingConstants {
    public static final String CLIENT = "Client";
    public static final String SERVER = "Server";
    public static final String MUST_UNDERSTAND = "MustUnderstand";
    public static final String VERSION_MISMATCH = "VersionMismatch";
    private static final String OBJECT = "object";
    private static final String NAME = "name";
    private static final String STACKTRACE = "stacktrace";
    private static final String SET_SOAP_CODE = "setSOAPCode";
    private static final String SET_SOAP_ACTOR = "setSOAPActor";
    private static final String SET_SOAP_DETAIL = "setSOAPDetail";
    private static final Class[] ONE_STRING = new Class[]{class$java$lang$String == null ? (class$java$lang$String = SOAPException.class$("java.lang.String")) : class$java$lang$String};
    private static final Object[] NO_OBJECTS = new Object[0];
    protected String code;
    protected String actor;
    protected Element detail;
    protected Throwable cause;
    protected boolean autoRethrow = true;
    static /* synthetic */ Class class$java$lang$String;

    public SOAPException(String message) {
        this(message, SERVER, null, (Element)null);
    }

    public SOAPException(String message, String code) {
        this(message, code, null, (Element)null);
    }

    public SOAPException(String message, String code, String actor, String detail) {
        super(message);
        this.code = code;
        this.actor = actor;
        try {
            this.detail = new Document(detail).getRoot();
        }
        catch (ParseException exception) {
            exception.printStackTrace();
        }
        if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
            Log.log(ILoggingConstants.EXCEPTION_EVENT, (Object)this.toString());
        }
    }

    public SOAPException(String message, String code, String actor, Element detail) {
        super(message);
        this.code = code;
        this.actor = actor;
        this.detail = detail;
        if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
            Log.log(ILoggingConstants.EXCEPTION_EVENT, (Object)this.toString());
        }
    }

    public SOAPException(Throwable throwable) {
        this(throwable, null);
    }

    public SOAPException(Throwable throwable, String code) {
        super(throwable.getMessage());
        this.code = code;
        this.cause = throwable;
        if (code == null && (code = this.getField(throwable, "getSOAPCode")) == null) {
            code = SERVER;
        }
        this.code = code;
        this.actor = this.getField(throwable, "getSOAPActor");
        String detailString = this.getField(throwable, "getSOAPDetail");
        if (detailString != null) {
            try {
                this.detail = new Document(detailString).getRoot();
            }
            catch (ParseException exception) {
                exception.printStackTrace();
            }
        }
        if (this.detail == null) {
            this.detail = new Element("detail");
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String stackTrace = stringWriter.toString();
            this.detail.setString(STACKTRACE, stackTrace);
        }
        if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
            Log.log(ILoggingConstants.EXCEPTION_EVENT, throwable);
        }
    }

    public SOAPException(Element fault) {
        super(fault.getElement("faultstring").getTextString());
        String faultCode = fault.getElement("faultcode").getTextString();
        Element actorXML = fault.getElement("faultactor");
        this.actor = actorXML == null ? null : actorXML.getTextString();
        this.detail = fault.getElement("detail");
        this.code = Strings.tail(faultCode, ':');
        Element tmeException = fault.getElement(SchemaProperties.getTmeNamespace(), "exception");
        if (tmeException != null) {
            this.initTMEException(tmeException);
        }
    }

    private void initTMEException(Element tmeException) {
        block6: {
            EncodedReader reader = new EncodedReader(tmeException);
            try {
                this.cause = (Throwable)reader.readObject(OBJECT);
            }
            catch (Exception exception) {
                try {
                    String name = reader.readString(NAME);
                    Class exceptionClass = ClassLoaders.loadClass(name);
                    Constructor constructor = exceptionClass.getConstructor(ONE_STRING);
                    String message = this.getMessage();
                    if (message == null) {
                        message = "\nServer side exception starts here:\n\n";
                        message = this.detail.hasElement(STACKTRACE) ? message + this.detail.getElement(STACKTRACE).getTextString() : message + this.detail.toString();
                        message = message + "\nEnd of server side exception\n";
                    }
                    this.cause = (Exception)constructor.newInstance(message);
                }
                catch (Throwable error) {
                    if (Log.isLogging("ERROR")) {
                        Log.log("ERROR", (Object)error.getMessage());
                    }
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block6;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, "Could not unmarshall server side exception.", error);
                }
            }
        }
    }

    public String toString() {
        return "SOAPException( " + this.code + ": " + this.getMessage() + " )";
    }

    public Throwable getCause() {
        return this.cause;
    }

    public String getSOAPCode() {
        return this.code;
    }

    public void setSOAPCode(String code) {
        this.code = code;
    }

    public String getSOAPActor() {
        return this.actor;
    }

    public void setSOAPActor(String actor) {
        this.actor = actor;
    }

    public String getSOAPDetail() {
        return this.detail == null ? null : this.detail.toString();
    }

    public void setSOAPDetail(String detail) throws ParseException {
        this.detail = new Document(detail).getRoot();
    }

    public void setSOAPDetailElement(Element detail) {
        this.detail = detail;
    }

    public Element getSOAPDetailElement() {
        return this.detail;
    }

    public void setAutoRethrow(boolean flag) {
        this.autoRethrow = flag;
    }

    public boolean getAutoRethrow() {
        return this.autoRethrow;
    }

    public void addFields(Element fault) {
        block4: {
            fault.setString("faultcode", "soap:" + this.code);
            fault.setString("faultstring", this.getMessage());
            if (this.actor != null) {
                fault.setString("faultactor", this.actor);
            }
            if (this.detail != null) {
                fault.addElement(this.detail);
            }
            if (this.cause == null || !this.autoRethrow) break block4;
            Element tmeException = fault.addElement();
            tmeException.setNamespace("tme", SchemaProperties.getTmeNamespace());
            tmeException.setName("tme", "exception");
            EncodedWriter writer = new EncodedWriter(tmeException);
            try {
                writer.writeString(NAME, this.cause.getClass().getName());
                writer.writeObject(OBJECT, (Object)this.cause);
            }
            catch (Throwable exception) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block4;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "adding detail to soap exception", exception);
            }
        }
    }

    public Throwable forRethrow(Class[] types) {
        if (this.cause == null) {
            return this;
        }
        try {
            int i = 0;
            while (i < types.length) {
                if (types[i].isInstance(this.cause)) {
                    this.setField(this.cause, SET_SOAP_CODE, this.getSOAPCode());
                    this.setField(this.cause, SET_SOAP_ACTOR, this.getSOAPActor());
                    this.setField(this.cause, SET_SOAP_DETAIL, this.getSOAPDetail());
                    return this.cause;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {}
        return this;
    }

    private void setField(Throwable throwable, String methodName, String value) {
        try {
            Method method = throwable.getClass().getMethod(methodName, ONE_STRING);
            method.invoke((Object)throwable, value);
        }
        catch (Exception exception) {}
    }

    private String getField(Throwable throwable, String methodName) {
        try {
            Method method = throwable.getClass().getMethod(methodName, null);
            return (String)method.invoke((Object)throwable, NO_OBJECTS);
        }
        catch (Exception error) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

