/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.locales;

import electric.servlet.InboundHTTPRequest;
import electric.servlet.locales.AcceptLanguageComparator;
import electric.servlet.locales.LocaleQuality;
import electric.util.http.IHTTPConstants;
import electric.util.sorting.BubbleSort;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class RequestLocales
implements IHTTPConstants {
    public static Vector getSortedLocales(InboundHTTPRequest request) {
        Vector<Locale> sortedLocales = new Vector<Locale>();
        String acceptLanguageHeader = RequestLocales.combineHeaders(request, "Accept-Language");
        Vector unsortedLocales = RequestLocales.getUnsortedLocales(acceptLanguageHeader);
        if (unsortedLocales.size() == 0) {
            Locale defaultServerLocale = Locale.getDefault();
            sortedLocales.addElement(defaultServerLocale);
        } else {
            Object[] localeQualityArray = new LocaleQuality[unsortedLocales.size()];
            unsortedLocales.copyInto(localeQualityArray);
            BubbleSort.sort(localeQualityArray, new AcceptLanguageComparator());
            int i = 0;
            while (i < localeQualityArray.length) {
                sortedLocales.addElement(((LocaleQuality)localeQualityArray[i]).locale);
                ++i;
            }
        }
        return sortedLocales;
    }

    private static Vector getUnsortedLocales(String acceptLanguageHeader) {
        Vector<LocaleQuality> locales = new Vector<LocaleQuality>();
        StringTokenizer commaTokenizer = new StringTokenizer(acceptLanguageHeader, ",");
        while (commaTokenizer.hasMoreTokens()) {
            String acceptLanguage = commaTokenizer.nextToken();
            try {
                LocaleQuality locale = RequestLocales.parseLanguage(acceptLanguage);
                if (locale == null) continue;
                locales.addElement(locale);
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        return locales;
    }

    private static LocaleQuality parseLanguage(String acceptLanguage) {
        int firstSemi = acceptLanguage.indexOf(";");
        String languageRange = null;
        float quality = 1.0f;
        if (firstSemi != -1) {
            languageRange = acceptLanguage.substring(0, firstSemi).trim();
            String qualityString = acceptLanguage.substring(firstSemi + 1).trim();
            int equalsPos = qualityString.indexOf("=");
            if (equalsPos != -1) {
                quality = Float.parseFloat(qualityString.substring(equalsPos + 1));
            }
        } else {
            languageRange = acceptLanguage;
        }
        StringTokenizer languageTok = new StringTokenizer(languageRange, "-");
        String language = null;
        String country = "";
        String variant = "";
        if (languageTok.hasMoreTokens()) {
            language = languageTok.nextToken();
        }
        if (languageTok.hasMoreTokens()) {
            country = languageTok.nextToken();
        }
        if (languageTok.hasMoreTokens()) {
            variant = languageTok.nextToken();
        }
        Locale locale = new Locale(language, country, variant);
        return new LocaleQuality(locale, quality);
    }

    private static String combineHeaders(InboundHTTPRequest request, String headerName) {
        String value = null;
        Enumeration headers = request.getHeaders(headerName);
        while (headers.hasMoreElements()) {
            String nextHeader = (String)headers.nextElement();
            value = value != null ? value + "," + nextHeader : nextHeader;
        }
        return value;
    }
}

