/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.dispatcher;

import electric.util.array.ArrayUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

class DispatcherRequest
implements HttpServletRequest {
    private HttpServletRequest request;
    private Hashtable overriddenParameters;
    private Hashtable overriddenAttributes;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private String queryString;

    protected DispatcherRequest(HttpServletRequest request, String contextPath, String servletPath, String pathInfo, String queryString) {
        this.request = request;
        this.contextPath = contextPath;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        if (queryString != null) {
            this.overriddenParameters = HttpUtils.parseQueryString((String)queryString);
        }
    }

    public Enumeration getParameterNames() {
        Hashtable paramClone = this.overriddenParameters != null ? (Hashtable)this.overriddenParameters.clone() : new Hashtable();
        Enumeration enumeration = this.request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            paramClone.put(enumeration.nextElement(), "");
        }
        return paramClone.keys();
    }

    public String getParameter(String name) {
        if (this.overriddenParameters != null && this.overriddenParameters.containsKey(name)) {
            Object paramValue = this.overriddenParameters.get(name);
            if (paramValue instanceof String) {
                return (String)paramValue;
            }
            return ((String[])paramValue)[0];
        }
        return this.request.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        Object overriddenValues;
        String[] values = this.request.getParameterValues(name);
        if (this.overriddenParameters == null || !this.overriddenParameters.containsKey(name)) {
            return values;
        }
        if (values == null) {
            values = new String[]{};
        }
        values = (overriddenValues = this.overriddenParameters.get(name)) instanceof String[] ? (String[])ArrayUtil.addElements(values, (String[])overriddenValues) : (String[])ArrayUtil.addElement(values, (String)overriddenValues);
        return values;
    }

    public Map getParameterMap() {
        Hashtable paramClone = (Hashtable)((Hashtable)this.request.getParameterMap()).clone();
        if (this.overriddenParameters == null) {
            return paramClone;
        }
        Enumeration enumeration = this.overriddenParameters.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            paramClone.put(key, this.overriddenParameters.get(key));
        }
        return paramClone;
    }

    protected void setOverriddenAttribute(String name, Object value) {
        if (this.overriddenAttributes == null) {
            this.overriddenAttributes = new Hashtable();
        }
        if (name == null) {
            return;
        }
        if (value == null) {
            this.removeOverriddenAttribute(name);
        } else {
            this.overriddenAttributes.put(name, value);
        }
    }

    public Object getAttribute(String name) {
        if (name == null) {
            return null;
        }
        if (this.overriddenAttributes != null && this.overriddenAttributes.containsKey(name)) {
            return this.overriddenAttributes.get(name);
        }
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public void setCharacterEncoding(String newEncoding) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(newEncoding);
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.request.getRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return this.request.getRealPath(path);
    }

    public void setAttribute(String name, Object object) {
        if (name == null) {
            return;
        }
        if (this.overriddenAttributes != null && this.overriddenAttributes.containsKey(name)) {
            this.setOverriddenAttribute(name, object);
        } else {
            this.request.setAttribute(name, object);
        }
    }

    public void removeAttribute(String name) {
        if (name == null) {
            return;
        }
        if (this.overriddenAttributes != null && this.overriddenAttributes.containsKey(name)) {
            this.removeOverriddenAttribute(name);
        } else {
            this.request.removeAttribute(name);
        }
    }

    protected void removeOverriddenAttribute(String name) {
        if (this.overriddenAttributes != null && this.overriddenAttributes != null && name != null) {
            this.overriddenAttributes.remove(name);
        }
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.getRequestURI());
    }

    public String getRequestURI() {
        if (this.contextPath == null) {
            return this.request.getRequestURI();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.contextPath);
        buffer.append(this.servletPath);
        buffer.append(this.pathInfo != null ? this.pathInfo : "");
        return buffer.toString();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.request.getIntHeader(name);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return this.pathInfo == null ? this.request.getPathInfo() : this.pathInfo;
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getContextPath() {
        return this.contextPath == null ? this.request.getContextPath() : this.contextPath;
    }

    public String getQueryString() {
        return this.queryString == null ? this.request.getQueryString() : this.queryString;
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getServletPath() {
        return this.servletPath == null ? this.request.getServletPath() : this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromUrl();
    }
}

