/*
 * Decompiled with CFR 0.152.
 */
package electric.service.instrumentation;

import electric.glue.IGLUEContextConstants;
import electric.proxy.IReference;
import electric.service.IService;
import electric.service.instrumentation.InstrumentingReference;
import electric.service.instrumentation.listener.IInstrumentationListener;
import electric.service.reference.IReferenceFactory;
import electric.util.array.ArrayUtil;
import java.util.Enumeration;

public class ReferenceFactory
implements IReferenceFactory,
IGLUEContextConstants {
    private IInstrumentationListener[] listeners = new IInstrumentationListener[0];

    public IReference newReference(IService service) {
        InstrumentingReference reference = new InstrumentingReference(service);
        int i = 0;
        while (i < this.listeners.length) {
            reference.addListener(this.listeners[i]);
            ++i;
        }
        Enumeration enumeration = service.getContext().getProperties("instrumentationListener");
        while (enumeration.hasMoreElements()) {
            reference.addListener((IInstrumentationListener)enumeration.nextElement());
        }
        return reference;
    }

    public void registerListener(IInstrumentationListener listener) {
        this.listeners = (IInstrumentationListener[])ArrayUtil.addElement(this.listeners, listener);
    }
}

