/*
 * Decompiled with CFR 0.152.
 */
package electric.service.ejb.client;

import electric.proxy.IProxy;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.service.ejb.client.HomeHandler;
import electric.service.ejb.client.JNDILookupInfo;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.proxy.ProxyFactory;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class GLUEInitialContext
implements Context,
ILoggingConstants {
    private static final String MISSING_PROVIDER_URL_ERROR = "missing JNDI properties, cannot obtain GLUE JNDI Prodider url";
    private static String brokerURL = null;
    private Context originalContext;
    private IProxy glueJndiProxy;

    public GLUEInitialContext(Hashtable jndiProps) throws NamingException {
        this.createOriginalContext(jndiProps);
        this.createGlueJndiProxy(jndiProps);
    }

    private void createGlueJndiProxy(Hashtable jndiProps) throws NamingException {
        if (jndiProps == null) {
            throw new NamingException(MISSING_PROVIDER_URL_ERROR);
        }
        brokerURL = (String)jndiProps.get("java.naming.provider.url");
        if (brokerURL == null) {
            throw new NamingException(MISSING_PROVIDER_URL_ERROR);
        }
        try {
            this.glueJndiProxy = Registry.bind(brokerURL);
        }
        catch (RegistryException exception) {
            String errorMsg = "unable to bind to GLUE JNDI web service at " + brokerURL;
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, errorMsg, exception);
            }
            throw new NamingException(errorMsg);
        }
    }

    private void createOriginalContext(Hashtable jndiProps) throws NamingException {
        this.originalContext = new InitialContext();
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        JNDILookupInfo lookupInfo;
        block7: {
            lookupInfo = null;
            try {
                lookupInfo = (JNDILookupInfo)this.glueJndiProxy.invoke("lookupObject", new Object[]{name});
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block7;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "unable to invoke service lookup", throwable);
            }
        }
        if (lookupInfo == null) {
            String errorMsg = "unable to retrieve JNDI object web service wrapper info from server. Check server log";
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, (Object)errorMsg);
            }
            throw new NamingException(errorMsg);
        }
        String wsdlURL = lookupInfo.getWsdlURL();
        Class remoteInterface = this.getInterface(lookupInfo.getRemoteInterface());
        Class homeInterface = this.getInterface(lookupInfo.homeInterface());
        try {
            Object beanProxy = Registry.bind(wsdlURL, remoteInterface);
            HomeHandler homeHandler = new HomeHandler(beanProxy);
            return ProxyFactory.newProxy(this.getClass().getClassLoader(), new Class[]{homeInterface}, homeHandler);
        }
        catch (RegistryException exception) {
            String errorMsg = "unable to bind to JNDI object web service wrapper at " + wsdlURL;
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, errorMsg, exception);
            }
            throw new NamingException(errorMsg);
        }
    }

    private Class getInterface(String interfaceName) {
        try {
            return Class.forName(interfaceName);
        }
        catch (ClassNotFoundException exception) {
            if (Log.isLogging(ILoggingConstants.ERROR_EVENT)) {
                Log.log(ILoggingConstants.ERROR_EVENT, (Object)("unable to find interface class on the client side " + interfaceName));
            }
            return null;
        }
    }

    public void bind(Name name, Object o) throws NamingException {
        this.originalContext.bind(name, o);
    }

    public void bind(String s, Object o) throws NamingException {
        this.originalContext.bind(s, o);
    }

    public void rebind(Name name, Object o) throws NamingException {
        this.originalContext.rebind(name, o);
    }

    public void rebind(String s, Object o) throws NamingException {
        this.originalContext.rebind(s, o);
    }

    public void unbind(Name name) throws NamingException {
        this.originalContext.unbind(name);
    }

    public void unbind(String s) throws NamingException {
        this.originalContext.unbind(s);
    }

    public void rename(Name name, Name name1) throws NamingException {
        this.originalContext.rename(name, name1);
    }

    public void rename(String s, String s1) throws NamingException {
        this.originalContext.rename(s, s1);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.originalContext.list(name);
    }

    public NamingEnumeration list(String s) throws NamingException {
        return this.originalContext.list(s);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.originalContext.listBindings(name);
    }

    public NamingEnumeration listBindings(String s) throws NamingException {
        return this.originalContext.listBindings(s);
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new RuntimeException("context operations not supported yet");
    }

    public void destroySubcontext(String s) throws NamingException {
        throw new RuntimeException("context operations not supported yet");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new RuntimeException("context operations not supported yet");
    }

    public Context createSubcontext(String s) throws NamingException {
        throw new RuntimeException("context operations not supported yet");
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.originalContext.lookupLink(name);
    }

    public Object lookupLink(String s) throws NamingException {
        return this.originalContext.lookupLink(s);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.originalContext.getNameParser(name);
    }

    public NameParser getNameParser(String s) throws NamingException {
        return this.originalContext.getNameParser(s);
    }

    public Name composeName(Name name, Name name1) throws NamingException {
        return this.originalContext.composeName(name, name1);
    }

    public String composeName(String s, String s1) throws NamingException {
        return this.originalContext.composeName(s, s1);
    }

    public Object addToEnvironment(String s, Object o) throws NamingException {
        return this.originalContext.addToEnvironment(s, o);
    }

    public Object removeFromEnvironment(String s) throws NamingException {
        return this.originalContext.removeFromEnvironment(s);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.originalContext.getEnvironment();
    }

    public void close() throws NamingException {
        this.originalContext.close();
    }

    public String getNameInNamespace() throws NamingException {
        return this.originalContext.getNameInNamespace();
    }
}

