/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms.wsdl;

import electric.glue.IGLUELoggingConstants;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.IServer;
import electric.server.Servers;
import electric.server.jms.IJMSConstants;
import electric.server.jms.JMSRequest;
import electric.service.IService;
import electric.util.XURL;
import electric.util.array.ByteArray;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.wsdl.WSDL;
import java.net.MalformedURLException;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

public class JMSToWSDL
implements IJMSConstants,
IGLUELoggingConstants {
    public void handle(JMSRequest request) {
        block9: {
            Queue responseQueue = request.getResponseQueue();
            if (responseQueue == null) {
                return;
            }
            QueueSession responseSession = request.createResponseSession();
            BytesMessage mainMessage = request.getMainMessage();
            try {
                String wsdlPath = mainMessage.getStringProperty("wsdlRequest");
                if (Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) {
                    Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)("wsdl request for " + wsdlPath));
                }
                String urn = Strings.head(wsdlPath, '.');
                BytesMessage response = responseSession.createBytesMessage();
                Object object = this.getService(urn);
                if (object instanceof IService) {
                    WSDL wsdl = ((IService)object).getWSDL();
                    ByteArray byteArray = wsdl.getDocument().getByteArray();
                    response.writeBytes(byteArray.bytes, byteArray.offset, byteArray.length);
                } else {
                    response.setStringProperty("wsdlNotFound", "service does not exist");
                }
                QueueSender sender = responseSession.createSender(responseQueue);
                response.setJMSCorrelationID(mainMessage.getJMSMessageID());
                sender.send((Message)response);
                sender.close();
            }
            catch (Throwable throwable) {
                if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, throwable);
                }
                try {
                    BytesMessage message = responseSession.createBytesMessage();
                    message.setStringProperty("wsdlNotFound", "exception while retrieving WSDL - " + throwable.toString());
                    QueueSender sender = responseSession.createSender(responseQueue);
                    message.setJMSCorrelationID(mainMessage.getJMSMessageID());
                    sender.send((Message)message);
                    sender.close();
                }
                catch (Exception exception) {
                    if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block9;
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, throwable);
                }
            }
        }
    }

    private Object getService(String serviceURN) throws RegistryException, MalformedURLException {
        IServer server = Servers.getServerForPath(new XURL(serviceURN));
        serviceURN = server.getLocalPath(serviceURN);
        return Registry.get(serviceURN);
    }
}

