/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms.tibco;

import com.tibco.tibjms.admin.ConnectionFactoryInfo;
import com.tibco.tibjms.admin.QueueInfo;
import com.tibco.tibjms.admin.TibjmsAdmin;
import com.tibco.tibjms.admin.TibjmsAdminException;
import com.tibco.tibjms.admin.TibjmsAdminNameExistsException;
import electric.glue.IGLUELoggingConstants;
import electric.server.jms.IJMSAdapter;
import electric.util.Context;
import electric.util.jms.JMSUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;

public class TibcoAdapter
implements IJMSAdapter,
IGLUELoggingConstants {
    public static final String SERVERURL = "tibcoServerURL";
    public static final String USERNAME = "tibcoServerUsername";
    public static final String PASSWORD = "tibcoServerPassword";
    public static final String SSLPARAMS = "tibcoConnectionSSLParams";
    private String serverURL = "tcp://localhost:7222";
    private String username = "admin";
    private String password = null;
    private Map sslParams = null;
    private Context context;
    private Hashtable jndiProps;
    private TibjmsAdmin admin;

    public void startup(Context context) throws JMSException, NamingException {
        this.context = context;
        this.serverURL = (String)Context.getProperty(context, SERVERURL, this.serverURL);
        this.username = (String)Context.getProperty(context, USERNAME, this.username);
        this.password = (String)Context.getProperty(context, PASSWORD, this.password);
        Map sslParams = (Map)Context.getProperty(context, SSLPARAMS);
        try {
            this.admin = sslParams != null ? new TibjmsAdmin(this.serverURL, this.username, this.password, sslParams) : new TibjmsAdmin(this.serverURL, this.username, this.password);
        }
        catch (TibjmsAdminException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new JMSException("unable to create TIBCO admin object due to exception - " + exception.toString());
        }
        this.admin.setAutoSave(true);
        Hashtable userJndiProps = (Hashtable)context.getProperty("jndiProperties");
        this.jndiProps = this.getJNDIProperties();
        if (userJndiProps != null) {
            JMSUtil.mergeProps(userJndiProps, this.jndiProps);
        }
    }

    public void shutdown() throws JMSException, NamingException {
        this.admin = null;
    }

    public boolean isStarted() {
        return this.admin != null;
    }

    public Context getStartupContext() {
        return this.context;
    }

    public Queue getQueue(String queueName, boolean create) throws JMSException, NamingException {
        if (create) {
            QueueInfo queueInfo = new QueueInfo(queueName);
            try {
                this.admin.createQueue(queueInfo);
                this.admin.bindQueue(queueName, queueName);
            }
            catch (TibjmsAdminNameExistsException exception) {
            }
            catch (TibjmsAdminException exception) {
                if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                }
                throw new JMSException("unable to create Queue using TIBCO admin due to exception - " + exception.toString());
            }
        }
        return JMSUtil.lookupQ(queueName, this.jndiProps);
    }

    public QueueConnectionFactory getQueueConnectionFactory(String queueConnFactoryName, boolean create) throws JMSException, NamingException {
        if (create) {
            ConnectionFactoryInfo connFactoryInfo = new ConnectionFactoryInfo(this.serverURL, "", 1, this.sslParams);
            try {
                this.admin.createConnectionFactory(queueConnFactoryName, connFactoryInfo);
            }
            catch (TibjmsAdminNameExistsException exception) {
            }
            catch (TibjmsAdminException exception) {
                if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                    Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
                }
                throw new JMSException("unable to create QueueConnectionFactory using TIBCO admin due to exception - " + exception.toString());
            }
        }
        return JMSUtil.lookupQConnFactory(queueConnFactoryName, this.jndiProps);
    }

    public String getClassName() {
        return "com.tibco.tibjms.naming.TibjmsInitialContextFactory";
    }

    public String getProviderName() {
        return "TIBCO Enterprise";
    }

    private Hashtable getJNDIProperties() {
        Hashtable<String, String> jndiProps = new Hashtable<String, String>();
        jndiProps.put("java.naming.factory.initial", "com.tibco.tibjms.naming.TibjmsInitialContextFactory");
        jndiProps.put("java.naming.provider.url", "tibjmsnaming://localhost:7222");
        return jndiProps;
    }
}

