/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms;

import electric.glue.IGLUELoggingConstants;
import electric.server.jms.IJMSAdapter;
import electric.server.jms.IJMSConstants;
import electric.server.jms.JMS;
import electric.soap.util.SOAPEnvelopes;
import electric.util.Context;
import electric.util.TimeoutException;
import electric.util.array.ByteArray;
import electric.util.async.Async;
import electric.util.async.IAsyncTransport;
import electric.util.jms.JMSUtil;
import electric.util.log.Log;
import electric.util.thread.ThreadPool;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import electric.xml.io.encoded.EncodedReader;
import electric.xml.io.encoded.EncodedWriter;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;

public class AsyncTransport
implements IAsyncTransport,
IJMSConstants,
MessageListener,
Runnable,
IGLUELoggingConstants {
    private static transient ThreadPool threadPool = ThreadPool.getShared();
    private String connectionFactoryName;
    private String queueName;
    private QueueSession queueSession;
    private String messageId;
    private Queue queue;
    private QueueReceiver queueReceiver;
    private transient Async callback;
    transient QueueConnection qConn;

    protected void finalize() {
        try {
            if (this.queueReceiver != null) {
                this.queueReceiver.close();
            }
            this.queueSession.close();
        }
        catch (JMSException exception) {
            exception.printStackTrace();
        }
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setQueueSession(QueueSession queueSession) {
        this.queueSession = queueSession;
    }

    public void setConnFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public void setQueueReceiver(QueueReceiver queueReceiver) {
        block2: {
            this.queueReceiver = queueReceiver;
            if (this.callback == null) break block2;
            try {
                this.registerListener();
            }
            catch (IOException exception) {
                this.callback.receivedException(exception);
            }
        }
    }

    public void writeResponse(Object message) throws IOException {
        Document responseDoc = SOAPEnvelopes.newEncodedEnvelope(null);
        Element bodyElement = responseDoc.getRoot().getElement("Body").addElement("object");
        EncodedWriter writer = new EncodedWriter(bodyElement);
        writer.writeObject(message);
        try {
            BytesMessage bytesMessage = this.queueSession.createBytesMessage();
            bytesMessage.setJMSCorrelationID(this.messageId);
            ByteArray byteArray = responseDoc.getByteArray();
            bytesMessage.writeBytes(byteArray.bytes, byteArray.offset, byteArray.length);
            QueueSender sender = this.queueSession.createSender(this.queue);
            sender.send((Message)bytesMessage);
            sender.close();
            this.queueSession.close();
        }
        catch (JMSException exception) {
            throw new IOException("unable to send message. - " + exception.toString());
        }
    }

    public Object getResponse(long timeout) throws IOException, TimeoutException {
        try {
            BytesMessage message = (BytesMessage)this.queueReceiver.receive(timeout);
            if (message == null) {
                throw new TimeoutException();
            }
            return this.processResponse(message);
        }
        catch (ParseException exception) {
            throw new IOException(exception.toString());
        }
        catch (JMSException exception) {
            throw new IOException(exception.toString());
        }
    }

    public Object getResponseNoWait() throws IOException {
        try {
            BytesMessage message = (BytesMessage)this.queueReceiver.receiveNoWait();
            return this.processResponse(message);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public Object getResponse() throws IOException {
        try {
            BytesMessage message = (BytesMessage)this.queueReceiver.receive();
            return this.processResponse(message);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public void setCallback(Async callback) throws IOException {
        this.callback = callback;
        this.registerListener();
    }

    public void onMessage(Message message) {
        Object response;
        try {
            response = this.processResponse((BytesMessage)message);
        }
        catch (Exception exception) {
            this.callback.receivedException(exception);
            return;
        }
        if (response instanceof Exception) {
            this.callback.receivedException((Exception)response);
        } else {
            this.callback.receivedResponse(response);
        }
    }

    public void run() {
        block4: {
            try {
                this.queueReceiver.close();
                this.queueSession.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (this.qConn == null) break block4;
            try {
                this.qConn.close();
            }
            catch (JMSException exception) {}
        }
    }

    private Object processResponse(BytesMessage message) throws IOException, ParseException {
        if (message == null) {
            return null;
        }
        byte[] bytes = JMSUtil.getMessageBytes(message);
        Document doc = new Document(bytes, null);
        Element resultRoot = doc.getRoot().getElement("Body").getFirstElement();
        EncodedReader reader = new EncodedReader(resultRoot);
        threadPool.run(this);
        return reader.readObject();
    }

    private void registerListener() throws IOException {
        if (this.queueReceiver != null) {
            try {
                this.queueReceiver.setMessageListener((MessageListener)this);
            }
            catch (JMSException exception) {
                throw new IOException(exception.toString());
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        IJMSAdapter jmsAdapter = JMS.getAdapter();
        Context startupContext = jmsAdapter.getStartupContext();
        EncodedWriter writer = new EncodedWriter("Context", SchemaProperties.getDefaultSchema(), "http://schemas.xmlsoap.org/soap/encoding/");
        writer.writeObject(startupContext);
        out.writeUTF(writer.getDocument().toString());
        out.writeUTF(this.connectionFactoryName);
        if (this.queueReceiver != null) {
            String messageSelector;
            out.writeBoolean(true);
            try {
                out.writeUTF(this.queueName);
                messageSelector = this.queueReceiver.getMessageSelector();
            }
            catch (JMSException exception) {
                throw new IOException("unable to serialize due to exception - " + exception.toString());
            }
            out.writeBoolean(messageSelector != null);
            if (messageSelector != null) {
                out.writeUTF(messageSelector);
            }
        } else {
            out.writeBoolean(false);
            out.writeUTF(this.messageId);
            out.writeUTF(this.queueName);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException {
        block9: {
            String queueName;
            IJMSAdapter jmsAdapter = JMS.getAdapter();
            boolean adminStartedHere = false;
            String startupContext = in.readUTF();
            if (!jmsAdapter.isStarted()) {
                this.startAdapter(jmsAdapter, startupContext);
                adminStartedHere = true;
            }
            this.connectionFactoryName = in.readUTF();
            boolean isClientSide = in.readBoolean();
            if (isClientSide) {
                queueName = in.readUTF();
                String messageSelector = null;
                boolean shouldGetSelector = in.readBoolean();
                if (shouldGetSelector) {
                    messageSelector = in.readUTF();
                }
                try {
                    QueueConnectionFactory factory = jmsAdapter.getQueueConnectionFactory(this.connectionFactoryName, false);
                    Queue queue = jmsAdapter.getQueue(queueName, false);
                    QueueConnection qConn = JMS.getQConnection(factory, true);
                    this.queueSession = JMS.createQSession(qConn);
                    this.queueReceiver = messageSelector == null ? JMS.createReceiver(this.queueSession, queue) : JMS.createReceiver(this.queueSession, queue, messageSelector);
                    qConn.start();
                }
                catch (Exception exception) {
                    throw new IOException("unable to deserialize due to exception - " + exception);
                }
            }
            this.messageId = in.readUTF();
            queueName = in.readUTF();
            try {
                QueueConnectionFactory factory = jmsAdapter.getQueueConnectionFactory(this.connectionFactoryName, false);
                QueueConnection qConn = JMS.getQConnection(factory, true);
                this.queueSession = JMS.createQSession(qConn);
                this.queue = jmsAdapter.getQueue(queueName, false);
                qConn.start();
            }
            catch (Exception exception) {
                throw new IOException("unable to deserialize due to exception - " + exception);
            }
            if (!adminStartedHere) break block9;
            try {
                jmsAdapter.shutdown();
            }
            catch (Exception exception) {
                if (!Log.isLogging(IGLUELoggingConstants.JMS_EVENT)) break block9;
                Log.log(IGLUELoggingConstants.JMS_EVENT, (Object)"exception while shutting down JMS adapter");
                Log.log(IGLUELoggingConstants.JMS_EVENT, (Throwable)exception);
            }
        }
    }

    private void startAdapter(IJMSAdapter jmsAdapter, String startupContext) throws IOException {
        EncodedReader reader = null;
        try {
            reader = new EncodedReader(new Document(startupContext));
        }
        catch (ParseException exception) {
            throw new IOException("unable to deserialize startup context - " + exception.toString());
        }
        Context context = (Context)reader.readObject();
        try {
            jmsAdapter.startup(context);
        }
        catch (Exception exception) {
            throw new IOException("unable to startup JMS adapter - " + exception.toString());
        }
    }
}

