/*
 * Decompiled with CFR 0.152.
 */
package electric.security.credentials;

import electric.glue.IGLUELoggingConstants;
import electric.security.ICredentials;
import electric.security.IRealm;
import electric.util.http.AuthHeaderData;
import electric.util.http.DigestUtil;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.security.NoSuchAlgorithmException;

public class DigestCredentials
implements ICredentials,
IGLUELoggingConstants {
    public AuthHeaderData authData;

    public DigestCredentials(AuthHeaderData data) {
        this.authData = data;
    }

    public String getUserName() {
        return this.authData.userName;
    }

    public boolean authenticate(IRealm realm) {
        String password = realm.getPassword(this.authData.userName);
        if (password == null || this.authData.response == null) {
            return false;
        }
        try {
            String digest = DigestUtil.calculateDigest(this.authData, password);
            return this.authData.response.equals(digest);
        }
        catch (NoSuchAlgorithmException exception) {
            if (Log.isLogging(ILoggingConstants.SECURITY_EVENT)) {
                Log.log(ILoggingConstants.SECURITY_EVENT, "DigestUtil needs MD5:", exception);
            }
            return false;
        }
    }
}

