/*
 * Decompiled with CFR 0.152.
 */
package electric.registry.security;

import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.security.guards.path.PathGuards;
import electric.service.IService;
import electric.util.Enumerations;
import electric.util.string.Strings;
import java.util.Enumeration;

public class RegistryGuards
extends PathGuards {
    private String root;
    private String servletPath;

    public RegistryGuards(String root, String servletPath) {
        this.root = root;
        this.servletPath = servletPath;
    }

    public boolean isEmpty() {
        return false;
    }

    public synchronized Enumeration getGuards(String path) {
        if (path.equals("/")) {
            return super.getGuards(this.root != null ? Strings.splice(this.root, path) : path);
        }
        if (this.servletPath != null && !path.startsWith(this.servletPath)) {
            return super.getGuards(path);
        }
        if (this.servletPath != null) {
            path = path.substring(this.servletPath.length());
        }
        if (this.root != null) {
            path = Strings.splice(this.root, path);
        }
        try {
            Enumeration guards;
            Object object = Registry.get(path);
            if (object instanceof IService && (guards = ((IService)object).getContext().getProperties("guard")).hasMoreElements()) {
                return new Enumerations(guards, super.getGuards(path));
            }
        }
        catch (RegistryException exception) {}
        return super.getGuards(path);
    }
}

